# -------------------------------------------------------------------------------------
# flo::plugin::File
# -------------------------------------------------------------------------------------
# Author : Jean-Michel Hiver <jhiver@mkdoc.com>
# Copyright : (c) MKDoc Holdings Ltd, 2003
# Description : Performs (possibly internal) redirects to serve files.
# -------------------------------------------------------------------------------------
package flo::plugin::File;
use MKDoc::Config;
use strict;
use warnings;
use 5.008_000;
use Carp;

use base qw /flo::ComponentPlugin/;


sub run
{
    my $self = shift;    
    my $component = $self->component();
    my $location  = $component->internal_location();
    
    if ($ENV{MOD_PERL})
    {
	# require ('Apache');
	my $r = Apache->request;
	$r->internal_redirect ($location);
    }
    else
    {
	my $cgi = flo::Standard::cgi();
	$cgi->path_info ($location);
	print $cgi->redirect ($cgi->self_url);
    }
    
    return 'TERMINATE';
}


sub activate
{
    my $self = shift;
    $self->SUPER::activate() || return;
    
    my $cgi = flo::Standard::cgi();
    my $path_info = $cgi->path_info;
    $path_info =~ /\,/ and return;
    
    my $component = $self->component;
    $component->can ('internal_location') || return;
    
    return 1;
}


1;


__END__
