# -------------------------------------------------------------------------------------
# flo::plugin::Poll
# -------------------------------------------------------------------------------------
#
#       Author : Jean-Michel Hiver (jhiver@cisedi.com).
#    Copyright : (c) MKDoc Holdings Ltd, 2001
# 
#      Unauthorized modification, use, reuse, distribution or redistribution
#      of this module is stricly forbidden
#
#    Description:
#
#      A plugin that is used to collect votes from Poll components, send cookies
#      to the navigators which have voted, and display results
#
# -------------------------------------------------------------------------------------
package flo::plugin::Poll;
use flo::HTTP::Date;
use flo::Standard;
use strict;
use warnings;


use base qw /flo::ComponentPlugin/;


sub template_path { 'poll' }


sub activate
{
    my $self = shift;
    $self->SUPER::activate() || return;
    $self->component()->isa ('flo::editor::Poll') || return;
    return 1;
}


sub run
{
    my $self = shift;    
    $self->{already_voted} = 0;
    $self->register_vote() and $self->set_has_voted_cookie();
    $self->render_http ( self => $self );
    return 'TERMINATE';
}


sub register_vote
{
    my $self = shift;
    $self->_register_vote_check_time()     and
    $self->_register_vote_check_provided() and
    $self->answer()                        and
    $self->_register_vote_nocheck();
}


sub _register_vote_check_time
{
    my $self = shift;
    my $poll  = $self->component();
    return $poll->is_started() and not $poll->is_stopped();
}


sub _register_vote_check_provided
{
    my $self = shift;
    my $cgi  = flo::Standard::cgi();
    my $poll = $self->component();
    defined $cgi->cookie ( -name => $self->cookie_name() . $poll->{id} ) and do {
	$self->{already_voted} = 1;
	return;
    };
    
    return 1;
}


sub config
{
    my $self = shift;
    return new MKDoc::Config ('flo.plugin.Poll');
}


sub _register_vote_nocheck
{
    my $self = shift;
    my $poll_result_t = flo::Standard::table ('Poll_Results');
    $poll_result_t->insert ( Poll_ID => $self->component()->{id}, Answer => $self->answer() );
    return 1;
}


sub cookie_name
{
    my $self = shift;
    return $self->config()->get ('cookie_name');
}


sub answer
{
    my $self   = shift;
    my $cgi    = flo::Standard::cgi();
    my $poll   = $self->component();
    my $answer = $cgi->param ('answer') || return;
    return unless ( $answer =~ /^answer/     and
		    defined $poll->{$answer} and
		    $poll->{$answer} ne '' );
    
    return $answer;
}


sub set_has_voted_cookie
{
    my $self        = shift;
    my $headers     = new flo::HTTP::Header;
    my $cookie_name = $self->cookie_name();
    my $far_away    = flo::HTTP::Date::http_date ( time + 5000 * 24 * 3600 );
    my $id          = $self->component()->{id};
    $headers->set ("Set-Cookie: $cookie_name$id=voted; path=/; expires=$far_away");
}


1;


__END__
