# -------------------------------------------------------------------------------------
# lib::sql::Query
# -------------------------------------------------------------------------------------
#
#       Author : Jean-Michel Hiver (jhiver@cisedi.com).
#    Copyright : (c) Jean-Michel Hiver, 2000.
# 
#      Unauthorized modification, use, reuse, distribution or redistribution
#      of this module is stricly forbidden.
#
#    Description:
#
#      This class represents queries performed onto the database. It also takes
#      care of marking strings which are pulled out the database as utf8.
#
# -------------------------------------------------------------------------------------
package lib::sql::Query;
use lib::Exception;
use Encode;
use strict;
use vars qw /$IMPORTED/;
$IMPORTED = {};


##
# $class->new;
# ------------
#   Constructs a new lib::sql::Query object.
##
sub new
{
    my $class = shift;
    $class = ref $class || $class;
    
    return bless { @_ }, $class;
}


##
# $obj->next;
# -----------
#   Returns next record, and bless it if necessary.
##
sub next
{
    my $self = shift;
    my $hash = $self->{sth}->fetchrow_hashref || return;
    my $bless_into = $self->{bless_into};
    
    if (defined $bless_into)
    {
	if (not $IMPORTED->{$bless_into})
	{
	    eval "use $bless_into" unless (defined $IMPORTED->{$bless_into});
	    $@ && warn "Cannot import $bless_into";
	    $IMPORTED->{$bless_into} = 1;
	}
	
	bless $hash, $bless_into if (ref $hash and defined $bless_into);
    }
    
    foreach my $key (keys %{$hash})
    {
	next unless (defined $hash->{$key});
	Encode::_utf8_on ($hash->{$key});
    }
    
    return $hash;
}


##
# $obj->fetch_all;
# ----------------
#   Returns an array of all objects that could be fetched
##
sub fetch_all
{
    my $self = shift;
    my @res  = ();

    my @array = ();    
    my $bless_into = $self->{bless_into};
    if (defined $bless_into)
    {
	eval "use $bless_into" unless (defined $IMPORTED->{$bless_into});
	$@ && warn "Cannot import $bless_into";
	
	while (my $hash = $self->{sth}->fetchrow_hashref)
	{
	    foreach my $key (keys %{$hash})
	    {
		next unless (defined $hash->{$key});
		Encode::_utf8_on ($hash->{$key});
	    }
	    bless $hash, $bless_into;
	    push @array, $hash;
	}
    }
    else
    {
	while (my $hash = $self->{sth}->fetchrow_hashref)
	{
	    foreach my $key (keys %{$hash})
	    {
		next unless (defined $hash->{$key});
		Encode::_utf8_on ($hash->{$key});
	    }
	    
	    push @array, $hash;
	}
    }
    
    return (wantarray) ? @array : \@array;
}


##
# $obj->fetch_all_firstvalue;
# ---------------------------
#   Returns an array of all objects that could be fetched
##
sub fetchall_arrayref
{
    my $self  = shift;
    my @array = @{$self->{sth}->fetchall_arrayref};
    for my $arry_ref (@array)
    {
	for (my $i=0; $i < scalar @{$arry_ref}; $i++)
	{
	    next unless (defined $arry_ref->[$i]);
	    Encode::_utf8_on ($arry_ref->[$i]);
	}
    }
    
    return \@array;
}


1;
