#!/usr/bin/perl
use strict;
use warnings;
use MKDoc::Handler::Initialize;
use MKDoc::Site::Check::Redirect;
use MKDoc::Util::Site_List;

$ENV{MKDOC_DIR} || die 'MKDOC_DIR is not defined!';


main();
sub main
{
    defined $ENV{SITE_DIR} and return do {
        MKDoc::Handler::Initialize::handler();
        MKDoc::Site::Check::Redirect->check();
    };
    
    foreach my $mkdoc_site (MKDoc::Util::Site_List::site_list())
    {
        print "CHECKING REDIRECTS: $mkdoc_site\n";
        $ENV{SITE_DIR} = $mkdoc_site;
        main();
    }
}


1;


__END__
