# -------------------------------------------------------------------------------------
# MKDoc
# -------------------------------------------------------------------------------------
# Author : Jean-Michel Hiver.
# Copyright : (c) MKDoc Holdings Ltd, 2003
#
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
# This is the top-level module of the MKDoc web-based document management system.
# It takes care of variable initialization, then triggers each plugin module in the
# order defined in the plugin config file given (see process()), until one of the 
# plugins returns the string 'TERMINATE'.
# -------------------------------------------------------------------------------------
package MKDoc::CompileCGI;
use CGI qw(-compile :all);

package MKDoc;
use lib qw /../;
use Petal;
use flo::Standard;
use MKDoc::Config;
use lib::sql::DBH;
use lib::sql::Table;
use CGI::Carp;
use Data::Dumper;
use strict;

use flo::plugin::Error;


our $CurrentPlugin = undef;


sub no_warning { $::MKD_IS_INIT }


##
# $class->process();
# ------------------
# Processes this query with the modules defined in $conf_file
##
sub process
{
    my $class = shift;
    init();
    eval { flo::Standard::cgi() };
    $@ and do {
	my $error_p = new flo::plugin::Error ( status => '400 Bad Request' );
	return $error_p->run();
    };

    # hack to make Petal temp files on a per-site basis
    {
        my $tmp_dir = $Petal::Cache::Disk::TMP;
        my $dir     = MKDoc::Config->CACHE_DIR() . '/petal';
        local $Petal::Cache::Disk::TMP = do { (-e $dir && -d $dir) ? $dir : undef } || $tmp_dir;
        main();
    }
}


sub init
{
    my $class = shift;
    unless ($::MKD_IS_INIT)
    {
	eval "use MKDoc::Handler::Initialize";
	defined $@ and $@ and die $@;
	MKDoc::Handler::Initialize::handler();
    }
}


##
# main;
# -----
# Processes the query. Triggers the main() class method of the
# plugins in the order they were defined in the config file. Plugins
# can terminate the query processing by sending the 'TERMINATE' string
# back.
##
sub main
{
    my @plugin = MKDoc::Config->config_lines ( MKDoc::Config->PLUGIN_LIST );
    local $MKDoc::CurrentPlugin;
    foreach my $pkg (@plugin)
    {
	main_import ($pkg);
	$MKDoc::CurrentPlugin = $pkg;
	my $ret = $pkg->main;
	last if (defined $ret and $ret eq 'TERMINATE');
    }
    
    + lib::sql::DBH->disconnect;
    my $document_table = flo::Standard::table ('Document');
    $document_table->lang (undef);
}


sub main_import
{
    my $pkg  = shift;

    my $file = $pkg;
    $file    =~ s/::/\//g;
    $file   .= '.pm';

    $INC{$file} && return;

    require $file;
    import $pkg;
}


1;


__END__
