# -----------------------------------------------------------------------------
# MKDoc::Site::ConfigWriter::MKDocRegistrer
# -----------------------------------------------------------------------------
# Author : Jean-Michel Hiver
# Copyright : Copyright (c) 2003 MKDoc Holdings Ltd.
#
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -----------------------------------------------------------------------------
package MKDoc::Site::ConfigWriter::MKDocRegistrer;
use strict;
use warnings;
use Carp;

use MKDoc::Site::Config;
use base qw /MKDoc::Site::ConfigWriter/;

sub class
{
    my $class = shift;
    return ref $class || $class;
}

##
# $class->setup();
# ----------------
# Writes the site.conf and httpd.conf and files.
##
sub setup
{
    my $class = shift;
    my $cfg = new MKDoc::Site::Config;
    
    my $mkdoc_dir = $cfg->{MKDOC_DIR};
    my $site_dir  = $cfg->{SITE_DIR};

    my %pathes = ();
    my $http_conf_file = File::Spec->canonpath ($mkdoc_dir . '/conf/httpd.conf');
    
    if (-e $http_conf_file)
    {
	open FP, "<$http_conf_file" || confess "Cannot read-open $http_conf_file: Reason $@";
        %pathes = map { chomp(); $_ => 1 } <FP>;
        close FP;
    }
    
    $pathes{"Include $site_dir/httpd.conf"} = 1;
    open FP, ">$http_conf_file" or confess "Cannot write-open $http_conf_file. Reason: $!";
    print FP join "\n", sort keys %pathes;
    print FP "\n";
    close FP;
}


1;
