# -------------------------------------------------------------------------------------
# MKDoc::Site::Deploy::DB::Schema
# -------------------------------------------------------------------------------------
#
#       Author : Jean-Michel Hiver
#                Steve Purkis <spurkis@mkdoc.com>
#    Copyright : Copyright (c) 2001-2002 MKDoc Holdings Ltd.
#
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Description:
#
#      Database table schemas needed by an MKDoc Site.
#
# -------------------------------------------------------------------------------------

package MKDoc::Site::Deploy::DB::Schema;

# This dependency comes from lib::sql::Table.
# Requiring it for the DB schema is bad, but necessary ATM.
use MKDoc;

use lib::sql::Table;
use lib::sql::Category;

use lib::sql::type::Char;
use lib::sql::type::DateTime;
use lib::sql::type::Int;
use lib::sql::type::Text;
use lib::sql::type::LongText;

sub class
{
    my $class = shift;
    return ref $class || $class;
}

## EDITOR TABLE ##
new lib::sql::Table
  (
   bless_into => 'flo::Record::Editor',
   name => 'Editor',
   pk   => [ qw /ID/ ],
   ai   => 1,
   cols => [
	    { name => 'ID',          type => new lib::sql::type::Int  ( not_null => 1) },
	    { name => 'Login',       type => new lib::sql::type::Char ( size => 15, not_null => 1 ) },
	    { name => 'Password',    type => new lib::sql::type::Char ( size => 15, not_null => 1 ) },
	    { name => 'Email',       type => new lib::sql::type::Char ( size => 255, not_null => 1 ) },
	    { name => 'First_Name',  type => new lib::sql::type::Char ( size => 50 ) },
	    { name => 'Family_Name', type => new lib::sql::type::Char ( size => 50 ) },
	    { name => 'Disabled',    type => new lib::sql::type::Int  ( not_null => 1 ) },
	   ],
   unique => { login_uk => [ qw /Login/ ] },
  );


## DOCUMENT TABLE ##
new lib::sql::Category
  (
   bless_into => 'flo::Record::Document',
   name => 'Document',
   ai   => 1,
   pk   => [ qw /ID/ ],
   cols => [
	    { name => 'ID',               type => new lib::sql::type::Int  ( not_null => 1 ), },
	    { name => 'Parent_ID',        type => new lib::sql::type::Int  (), },
	    { name => 'Cache_Control',    type => new lib::sql::type::Int  ( not_null => 1 ), },
	    { name => 'Template',         type => new lib::sql::type::Char ( not_null => 1, size => 255 ), },
	    { name => 'Description',      type => new lib::sql::type::Text ( not_null => 1 ), },
	    { name => 'Keywords',         type => new lib::sql::type::Text ( not_null => 1 ), },
	    { name => 'Date_Created',     type => new lib::sql::type::DateTime ( not_null => 1 ), },
	    { name => 'Date_Last_Modified',      type => new lib::sql::type::DateTime ( not_null => 1 ), },
	    { name => 'Editor_Created_ID',       type => new lib::sql::type::Int ( not_null => 1 ), },
	    { name => 'Editor_Last_Modified_ID', type => new lib::sql::type::Int ( not_null => 1 ), },
	    { name => 'Name',             type => new lib::sql::type::Char ( not_null => 1, size => 50 ), },
	    { name => 'Full_Path',        type => new lib::sql::type::Char ( not_null => 1, size => 255 ), },
	    { name => 'Title',            type => new lib::sql::type::Char ( not_null => 1, size => 255 ), },
	    { name => 'Lang',             type => new lib::sql::type::Char ( not_null => 1, size => 8 ), },
	    { name => 'Rights',           type => new lib::sql::type::Text (), },
	    { name => 'Publisher',        type => new lib::sql::type::Text (),   },
	    { name => 'Source',           type => new lib::sql::type::Text (), },
	    { name => 'Relation',         type => new lib::sql::type::Text (), },
	    { name => 'Coverage',         type => new lib::sql::type::Text (), },
	    { name => 'Body',             type => new lib::sql::type::LongText(), },
	    { name => 'Sibling_Position', type => new lib::sql::type::Int  (), },
	    { name => 'Sort_By',          type => new lib::sql::type::Char ( size => 50 ), },
	    { name => 'Order_By',         type => new lib::sql::type::Int  (), }
	   ],
   unique => { Full_Path_UK => [ qw /Full_Path/ ] },
   index  => { Parent_ID_IDX => [ qw /Parent_ID/ ] },
   '.lang'           => 'en',
   category_path     => 'Full_Path',
   category_id       => 'ID',
   category_name     => 'Name',
   category_parent   => 'Parent_ID',
   category_position => 'Sibling_Position',
   weight => {
	      Keywords    => 10,
	      Description => 8,
	      Title       => 10,
	      Name        => 10,
	      Full_Path   => 5,
	      Lang        => 3,
	      Rights      => 3,
	      Publisher   => 3,
	      Relation    => 3,
	      Coverage    => 3,
	      Body        => 1,
	     },
   fk => {
	  Editor => {
		     Editor_Created_ID       => 'ID',
		     Editor_Last_Modified_ID => 'ID',
		    },
	 },
  );


## BASE_DOCUMENT TABLE ##
new lib::sql::Table
  (
   name => 'Base_Document',
   pk   => [ qw /ID/ ],
   ai   => 1,
   cols => [
	    { name => 'ID',          type => new lib::sql::type::Int ( not_null => 1 ), },
	    { name => 'Editor_ID',   type => new lib::sql::type::Int ( not_null => 1 ), },
	    { name => 'Document_ID', type => new lib::sql::type::Int ( not_null => 1 ), },
	   ],
   fk => {
	  Document => { Document_ID => 'ID' },
	  Editor   => { Editor_ID   => 'ID' },
	 },
   unique => { Editor_Document_Owner_uk => [ qw /Editor_ID Document_ID/ ], },
  );


## CONTRIBUTOR TABLE ##
new lib::sql::Table
  (
   bless_into => 'flo::Record::Contributor',
   name => 'Contributor',
   pk   => [ qw /ID/ ],
   ai   => 1,
   cols => [
	    { name => 'ID',          type => new lib::sql::type::Int ( not_null => 1 ), },
	    { name => 'Editor_ID',   type => new lib::sql::type::Int ( not_null => 1 ), },
	    { name => 'Document_ID', type => new lib::sql::type::Int ( not_null => 1 ), },
	   ],
   fk => {
	  Document => { Document_ID => 'ID' },
	  Editor   => { Editor_ID   => 'ID' },
	 },
   unique => { Editor_Document_Contributor_uk => [ qw /Editor_ID Document_ID/ ] },
  );


## DOCUMENT INDEX TABLE ##
new lib::sql::Table
  (
   name => 'Document_Index',
   pk   => [ qw /ID/ ],
   ai   => 1,
   cols => [
	    { name => 'ID',          type => new lib::sql::type::Int  ( not_null => 1 ), },
	    { name => 'Record_ID',   type => new lib::sql::type::Int  ( not_null => 1 ), },
	    { name => 'Column_Name', type => new lib::sql::type::Char ( not_null => 1, size => 50 ), },
	    { name => 'Keyword',     type => new lib::sql::type::Char ( not_null => 1, size => 100 ), }
	   ],
   index  => { DocumentIndex => [ qw /Keyword/ ] },
   fk     => { Document => { Record_ID => 'ID' } },
   unique => { RecordKeywordUK => [ qw /Record_ID Column_Name Keyword/ ] },
  );


## POLL_RESULTS TABLE ##
new lib::sql::Table
  (
   name => 'Poll_Results',
   pk   => [ qw /ID/ ],
   ai   => 1,
   cols => [
	    { name => 'ID',      type => new lib::sql::type::Int  ( not_null => 1 ), },
	    { name => 'Poll_ID', type => new lib::sql::type::Char ( size => 100, not_null => 1 ), },
	    { name => 'Answer',  type => new lib::sql::type::Char ( size => 100, not_null => 1 ), },
	   ],
  );


## REDIRECT TABLE ##
new lib::sql::Table
  (
   bless_into => 'flo::Record::Redirect',
   name => 'Redirect',
   pk   => [ qw /ID/ ],
   ai   => 1,
   cols => [
	    { name => 'ID',       type => new lib::sql::type::Int  ( not_null => 1 ), },
	    { name => 'Old_Path', type => new lib::sql::type::Char ( not_null => 1, size => 255 ), },
	    { name => 'New_Path', type => new lib::sql::type::Char ( not_null => 1, size => 255 ), },
	   ],
   unique => { 'Old_New_Uk' => [ qw /Old_Path/ ] },
  );


## SESSION TABLE ##
new lib::sql::Table
  (
   name => 'Session',
   pk   => [ qw /ID/ ],
   ai   => undef,
   cols => [
	    { name => 'ID',        type => new lib::sql::type::Char ( not_null => 1, size => 50 ), },
	    { name => 'Last_Time', type => new lib::sql::type::Int  ( not_null => 1 ), },
	    { name => 'IP',        type => new lib::sql::type::Char ( size => 20 ), },
	    { name => 'Editor_ID', type => new lib::sql::type::Int  ( not_null => 1 ), },
	   ],
   fk => { Editor => { Editor_ID => 'ID' } },
  );


## AUDIENCE TABLE ##
# TODO: deprecate use of 'Value' - use 'Name' instead
new lib::sql::Table
  (
   bless_into => 'flo::Record::Audience',
   name => 'Audience',
   pk   => [ qw /ID/ ],
   ai   => 1,
   cols => [
	    { name => 'ID',    type => new lib::sql::type::Int  ( not_null => 1 ) },
##	    { name => 'Name',  type => new lib::sql::type::Char ( size => 255, not_null => 1 ) },
	    { name => 'Value', type => new lib::sql::type::Char ( size => 255, not_null => 1 ) },
	    { name => 'Label', type => new lib::sql::type::Char ( size => 255, not_null => 1 ) },
	   ],
## unique => { Name_uk => [ qw /Name/ ] },
   unique => { Name_uk => [ qw /Value/ ] },
  );


## DOCUMENT AUDIENCE TABLE ##
new lib::sql::Table
  (
   bless_into => 'flo::Record::Document_Audience',
   name => 'Document_Audience',
   pk   => [ qw /ID/ ],
   ai   => 1,
   cols => [
	    { name => 'ID',          type => new lib::sql::type::Int ( not_null => 1 ) },
	    { name => 'Document_ID', type => new lib::sql::type::Int ( not_null => 1 ) },
	    { name => 'Audience_ID', type => new lib::sql::type::Int ( not_null => 1 ) },
	   ],
   fk => {
	  Document => { Document_ID => 'ID' },
	  Audience => { Audience_ID => 'ID' },
	 },
  );


## GENERIC PREFERENCE TABLE ##
new lib::sql::Table
  (
   bless_into => 'flo::Record::Preference',
   name => 'Preference',
   pk   => [ qw /ID/ ],
   ai   => 1,
   cols => [
	    { name => 'ID',        type => new lib::sql::type::Int  ( not_null => 1 ) },
	    { name => 'Editor_ID', type => new lib::sql::type::Int  ( not_null => 1 ) },
	    { name => 'Name',      type => new lib::sql::type::Char ( size => 255, not_null => 1 ) },
	    { name => 'Value',     type => new lib::sql::type::Char ( size => 255, not_null => 1 ) },
	   ],
   fk => { Editor => { Editor_ID => 'ID' } },
  );


## AUDIENCE PREFERENCE TABLE ##
new lib::sql::Table
  (
   bless_into => 'flo::Record::Preference::Audience',
   name => 'Preference_Audience',
   pk   => [ qw /ID/ ],
   ai   => 1,
   cols => [
	    { name => 'ID',          type => new lib::sql::type::Int ( not_null => 1 ) },
	    { name => 'Editor_ID',   type => new lib::sql::type::Int ( not_null => 1 ) },
	    { name => 'Audience_ID', type => new lib::sql::type::Int ( not_null => 1 ) },
	    { name => 'Value',       type => new lib::sql::type::Int ( not_null => 1 ) },
	   ],
   fk => {
	  Editor   => { Editor_ID   => 'ID' },
	  Audience => { Audience_ID => 'ID' },
	 },
  );


## LANGUAGE PREFERENCE TABLE ##
new lib::sql::Table
  (
   bless_into => 'flo::Record::Preference::Language',
   name => 'Preference_Language',
   pk   => [ qw /ID/ ],
   ai   => 1,
   cols => [
	    { name => 'ID',          type => new lib::sql::type::Int  ( not_null => 1 ) },
	    { name => 'Editor_ID',   type => new lib::sql::type::Int  ( not_null => 1 ) },
	    { name => 'Language_ID', type => new lib::sql::type::Char ( size => 25, not_null => 1 ) },
	    { name => 'Value',       type => new lib::sql::type::Int  ( not_null => 1 ) },
	   ],
   fk => { Editor => { Editor_ID => 'ID' } },
  );


# TICKETS TABLE #
new lib::sql::Table
  (
   bless_into => 'flo::Record::Ticket',
   name => 'Tickets',
   pk   => [ qw /ID/ ],
   cols => [
	    { name => 'ID',         type => new lib::sql::type::Char     ( size => 25, not_null => 1 ) },
	    { name => 'ExpiryDate', type => new lib::sql::type::DateTime ( not_null => 1 ) },
	    { name => 'Email',      type => new lib::sql::type::Char     ( size => 255 ) },
	    { name => 'Action',     type => new lib::sql::type::Char     ( size => 25 ) },
	   ],
  );


1;

__END__
