#!/usr/bin/perl
# -------------------------------------------------------------------------------------
#       Author : Jean-Michel Hiver.
#    Copyright : (c) MKDoc Holdings Ltd, 2003
#
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
#    Description:
#
#      Tiny wrapper script which pulls and triggers MKDoc.pm which controls the
#      execution flow of the program.
# -------------------------------------------------------------------------------------
use MKDoc;
use Data::Dumper;
use strict;
use warnings;


eval
{
    $ENV{DUMP_CGI} and do {
        my $cgi = flo::Standard::cgi();
        my $path_info = $cgi->path_info();
        my $rand = join '', map { chr (ord ('a') + int rand (26)) } 1..10;
        my $file_to_dump = $ENV{DUMP_CGI} . '/' . time() . "-$$-$rand.pl";

        open FP, ">$file_to_dump" or die "Cannot dump file $file_to_dump";
        print FP "\nMKDoc::CGI->new();";
        print FP "\n\$::MKD_CGI->path_info ('$path_info');";
        for ($cgi->param()) {
            my $value = quotemeta ($cgi->param ($_));
            print FP "\n\$::MKD_CGI->param ($_ => '$value');";
        }
        close FP;
    };

    MKDoc->process();
};


if (defined $@ and $@)
{
    print "Status: 500 Internal Server Error\n";
    print "Content-Type: text/html; charset=UTF-8\n\n";
    if (ref $@) { $@ = Dumper ($@) }
    $@ = Dumper (\%ENV) . "\n\n" . $@;
    warn "SOFTWARE_ERROR\n\n" . $@ . "\n\n";
}


BEGIN {
    $SIG{'__WARN__'} = sub {
	# trap some common error strings that otherwise flood the log files
	warn $_[0] unless ($_[0] =~ /byte of utf8 encoded char at/ or
			   $_[0] =~ /is deprecated/                or
                           $_[0] =~ /IMAPClient\.pm line/);
    }
}


1;
