# -------------------------------------------------------------------------------------
# flo::DocumentPlugin
# -------------------------------------------------------------------------------------
# Author    : Jean-Michel Hiver
# Copyright : (c) 2003, MKDoc Holdings Ltd
#
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# A base module for MKDoc plugins which operate on Document objects.
# -------------------------------------------------------------------------------------
package flo::DocumentPlugin;
use strict;
use warnings;
use Encode;
use Carp;
use flo::Standard;
use flo::HTTP::Header;
use 5.008_000;

use base qw /flo::Plugin/;
our $AUTOLOAD = undef;


sub equals
{
    my $self  = shift;
    my $stuff = shift;
    return $self->document()->equals ($stuff);
}


sub activate
{
    my $self = shift;
    flo::Standard::raw_path_info          || return;
    flo::Standard::raw_path_info =~ /\/$/ || return;
    $self->document()                     || return;
    return 1;
}


sub document
{
    my $self = shift;
    return flo::Standard::current_document();
}


sub path
{
    my $self = shift;
    return $self->document()->path();
}


sub title
{
    my $self = shift;
    return $self->document()->title();
}


sub parent
{
    my $self = shift;
    return $self->document()->parent();
}


sub lang
{
    my $self = shift;
    return $self->document()->language();
}


sub AUTOLOAD
{
    my $self  = shift;
    my ($met) = $AUTOLOAD =~ /.*::(.*)/;
    return $self->document()->$met (@_) if ($self->document()->can ($met));
    die "Cannot invoke method $met on $self";
}


sub DESTROY
{
}


1;


__END__
