# -------------------------------------------------------------------------------------
# flo::HTTP::Date
# -------------------------------------------------------------------------------------
#
#       Author : Jean-Michel Hiver.
#    Copyright : (c) MKDoc Holdings Ltd, 2001
#
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
#    Description :
#
#      Returns an HTTP date given an input in non-leap seconds since the epoch
#      such as time().
#
# -------------------------------------------------------------------------------------
package flo::HTTP::Date;
use 5.008_000;
use utf8;
use Encode qw /encode decode _utf8_on is_utf8/;
use strict;


##
# http_date;
# ----------
#   This function can be called with no arguments, in which case it'll
#   give the current date in a format which is suitable for HTTP headers.
#
#   If called with an argument (number of seconds since the epoch), it'll
#   give the date for the date maching the argument.
##
sub http_date
{
    my $localtime = shift || time; # u_shift
    my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = gmtime ($localtime);
    my @weekday = qw /Sun Mon Tue Wed Thu Fri Sat/;
    my @month   = qw /Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec/;
    $wday = $weekday[$wday];
    $mon  = $month[$mon];
    $year += 1900;
    $mday = '0' . $mday if (length $mday == 1);
    $hour = '0' . $hour if (length $hour == 1);
    $min  = '0' . $min  if (length $min == 1);
    $sec  = '0' . $sec  if (length $sec == 1);
    
    my $res = "$wday, $mday $mon $year $hour:$min:$sec GMT";
    _utf8_on ($res) unless (is_utf8 ($res));
    return $res;
}


1;
