# -------------------------------------------------------------------------------------
# flo::Record::Redirect
# -------------------------------------------------------------------------------------
#
#       Author : Jean-Michel Hiver.
#    Copyright : (c) MKDoc Holdings Ltd, 2000.
#
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
#    Description:
#
#      Every record from the 'Redirect' table will be blessed into this class
#      so that we can add extra method to access to in the template engine.
#
# -------------------------------------------------------------------------------------
package flo::Record::Redirect;
use flo::Standard;
use strict;
use 5.008_000;


##
# $self->id;
# ----------
#   Returns the ID for this flo::Record::Editor.
##
sub id
{
    my $self = shift;
    return $self->{ID};
}


##
# $self->set_id ($id);
# --------------------
#   $id - New ID for this flo::Record::Editor
# 
#   Sets the ID for this flo::Record::Editor object.
##
sub set_id
{
    my $self = shift;
    $self->{ID} = shift;
}


##
# $self->old_path;
# ----------------
#   Gets the Old_Path attribute of this object.
##
sub old_path
{
    my $self = shift;
    return $self->{Old_Path};
}


##
# $self->set_old_path ($old_path);
# --------------------------------
#   $old_path - The old path that this redirect represents.
#
#   Sets the Old_Path attribute of this object.
##
sub set_old_path
{
    my $self = shift;
    $self->{Old_Path} = shift;
}


##
# $self->new_path;
# ----------------
#   Gets the New_Path attribute of this object.
##
sub new_path
{
    my $self = shift;
    return $self->{New_Path};
}


##
# $self->set_new_path ($new_path);
# --------------------------------
#   $new_path - The new path that this redirect represents.
#
#   Sets the New_Path attribute of this object.
##
sub set_new_path
{
    my $self = shift;
    $self->{New_Path} = shift;
}


##
# $self->old_uri;
# ---------------
#   Computes the Old URI for that redirect from the Old_Path and
#   the CGI object
##
sub old_uri
{
    my $self  = shift;
    my $cgix  = flo::Standard::cgi()->new;
    foreach ($cgix->param) { $cgix->delete ($_) }
    $cgix->path_info ($self->Old_Path);
    return $cgix->self_url;
}


##
# $self->new_uri;
# ---------------
#   Computes the Old URI for that redirect from the New_Path and
#   the CGI object
##
sub new_uri
{
    my $self  = shift;
    my $cgix  = flo::Standard::cgi()->new;
    foreach ($cgix->param) { $cgix->delete ($_) }
    $cgix->path_info ($self->New_Path);
    return $cgix->self_url;
}


sub uri { return shift->old_uri ( @_ ) }


## DEPRECATED STUFF THAT'LL NEED TO GO AWAY ##


##
# $self->ID; (DEPRECATED)
# ----------
#   alias for id().
##
sub ID
{
    my $self = shift;
    $self->set_id (shift) if (@_);
    return $self->id;
}


##
# $self->Old_Path; (DEPRECATED)
# ----------------
#   alias for old_path().
##
sub Old_Path
{
    my $self = shift;
    $self->set_old_path (shift) if (@_);
    return $self->old_path;
}


##
# $self->New_Path; (DEPRECATED)
# ----------------
#   alias for new_path().
##
sub New_Path
{
    my $self = shift;
    $self->{New_Path} = shift || return $self->{New_Path};
}


##
# $self->Old_URI; (DEPRECATED)
# ---------------
#   alias for old_uri();
##
sub Old_URI
{
    my $self  = shift;
    return $self->old_uri;
}


##
# $self->New_URI; (DEPRECATED)
# ---------------
#   alias for new_uri();
##
sub New_URI
{
    my $self = shift;
    return $self->new_uri;
}


1;

__END__


=head1 NAME

 flo::Record::Redirect


=head1 DESCRIPTION

    Author : Jean-Michel Hiver.
    Copyright : (c) MKDoc Holdings Ltd, 2000.
 
    Unauthorized modification, use, reuse, distribution or redistribution
    of this module is stricly forbidden.

    Description:

    Every record from the 'Redirect' table will be blessed into this class
    so that we can add extra method to access to in the template engine.


=head1 FUNCTIONS / METHODS

=head2  $self->id;


Returns the ID for this flo::Record::Editor.


=head2  $self->set_id ($id);


$id - New ID for this flo::Record::Editor
 
Sets the ID for this flo::Record::Editor object.


=head2  $self->old_path;


Gets the Old_Path attribute of this object.


=head2  $self->set_old_path ($old_path);


$old_path - The old path that this redirect represents.

Sets the Old_Path attribute of this object.


=head2  $self->new_path;


Gets the New_Path attribute of this object.


=head2  $self->set_new_path ($new_path);


$new_path - The new path that this redirect represents.

Sets the New_Path attribute of this object.


=head2  $self->old_uri;


Computes the Old URI for that redirect from the Old_Path and
the CGI object


=head2  $self->new_uri;


Computes the Old URI for that redirect from the New_Path and
the CGI object


=head2  $self->ID; (DEPRECATED)





alias for id().


=head2  $self->Old_Path; (DEPRECATED)


alias for old_path().


=head2  $self->New_Path; (DEPRECATED)


alias for new_path().


=head2  $self->Old_URI; (DEPRECATED)


alias for old_uri();


=head2  $self->New_URI; (DEPRECATED)


alias for new_uri();


