# -------------------------------------------------------------------------------------
# flo::plugin::Account::Remove
# -------------------------------------------------------------------------------------
# Author : Steve Purkis <spurkis@mkdoc.com>
# Copyright : (c) 2003, MKDoc Holdings Ltd.
#
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------------------
package flo::plugin::Account::Remove;
use flo::Record::Ticket;
use flo::Record::Editor;
use flo::Standard;

use Carp;
use Petal;
use Petal::Mail;

use MKDoc::Config;
use MKDoc::Error;

use strict;
use 5.008_000;
use utf8;

use constant ACTION => 'remove';
use constant DEFAULT_EXPIRY_TIME => 7*24*60*60;

use base qw /flo::Plugin/;

sub template_path { '/account/remove' }


##
# $self->http_get;
# ----------------
# Displays the form which lets the editor choose which audiences
# the current document relates to.
##
sub http_get
{
    my $self = shift;
    $self->_create_ticket();
    $self->_send_mail();
    $self->render_http (
	self       => $self,
	object     => $self->parent,
	__input__  => 'XML',
	__output__ => 'XHTML',
       );    
    return 'TERMINATE';
}


##
# $self->_create_ticket;
# ----------------------
# Creates the ticket and inserts it in the database.
# Returns the newly created ticket.
##
sub _create_ticket
{
    my $self  = shift;
    my $email = $self->user()->email();
    
    # clear old tickets & remove previous tickets
    # this is so that a user can re-ask for a ticket
    # rather than wait for his ticket to have expired
    flo::Record::Ticket::clear_old_tickets_from_db();
    my $ticket_table = flo::Standard::table ('Tickets');
    $ticket_table->delete ( Email => $email, Action => ACTION );
    
    # create a new ticket and returns it
    my $ticket = new flo::Record::Ticket;
    eval {
	$ticket->generateId;
	$ticket->Email ($email);
	$ticket->ExpiryDate (time + DEFAULT_EXPIRY_TIME);
	$ticket->Action ( ACTION );
	$ticket->saveToDb();
    };
    
    defined $@ and $@ and do {
	warn $@;
	new MKDoc::Ouch 'mail/cannot_create';
    };
    
    $self->{ticket} = $ticket;
    return $ticket;
}


##
# $self->_send_mail ($ticket);
# ----------------------------
# Sends the email...
##
sub _send_mail
{
    my $self   = shift;
    
    my $xml_mail = eval {
        my $mail = new Petal::Mail (
            file => '/account/emails/remove',
            language => $self->language(),
        );
        $mail->send (
	    self       => $self,
	    object     => $self->parent(),
	    __input__  => 'XML',
	    __output__ => 'XML',
	);
    };
    defined $@ and $@ and do {
	warn $@;
	new MKDoc::Ouch 'mail/cannot_create';
	return 0;
    };

    return 1;
}


1;


__END__
