package flo::plugin::Admin::AudienceInsert;
use strict;
use warnings;
use flo::Standard;
use flo::Record::Audience;
use base qw /flo::Plugin/;


sub activate
{
    my $self = shift;
    $self->SUPER::activate (@_) || return;
    $self->user()->id() == 1    || return;
    return 1;
}


sub template_path { 'admin/audience_insert' }


sub http_get
{
    my $self = shift;
    $self->render_http (
	self => $self,
	__output__ => 'XHTML',
       );
    
    return 'TERMINATE';
}


sub http_post
{
    my $self = shift;
    my $cgi  = flo::Standard::cgi();
    
    my $name = $cgi->param ('name');
    $name =~ s/[^A-Za-z0-9]/-/g;
    $name =~ s/-+/-/g;
    $name =~ s/^[^A-Za-z0-9]+//;
    $name =~ s/[^A-Za-z0-9]+$//;
    $name = lc ($name);
    my $audience = new flo::Record::Audience (
	Value       => $name || '',
	Label       => $cgi->param ('label') || '',
       );
    
    my $audience_t = flo::Standard::table ('Audience');
    
    $audience->name() or do {
	new MKDoc::Ouch 'audience/name/empty';
	return $self->http_get();
    };
    
    length ($audience->name()) < 255 or do {
	new MKDoc::Ouch 'audience/name/too_long';
	return $self->http_get();
    };
    
    $audience_t->get ( Value => $audience->name() ) and do {
	new MKDoc::Ouch 'audience/name/exists';
	return $self->http_get();
    };
    
    $audience->label() or do {
	new MKDoc::Ouch 'audience/label/empty';
	return $self->http_get();
    };
    
    length ($audience->label()) < 255 or do {
	new MKDoc::Ouch 'audience/label/too_long';
	return $self->http_get();
    };
    
    $self->has_errors() and return $self->http_get();
    $audience_t->insert ($audience);
    
    $self->{ok} = 1;
    $cgi->delete ($cgi->param());
    return $self->http_get();
}


1;
