# -------------------------------------------------------------------------------------
# flo::plugin::Admin::New
# -------------------------------------------------------------------------------------
#
#       Author : Jean-Michel Hiver
#    Copyright : (c) MKDoc Holdings Ltd, 2002
#
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
#    Description:
#
# -------------------------------------------------------------------------------------
package flo::plugin::Admin::New;
use flo::RedirectManager;
use MKDoc::Config;
use MKDoc::Error;
use flo::Standard qw /cgi table current_document/;
use flo::plugin::Admin::Content;
use flo::Editor;
use strict;
use warnings;
use 5.008_000;
use Carp;

use base qw /flo::plugin::Admin::Properties/;

sub template_path { '/admin/new' }


##
# $self->audiences;
# -----------------
#   Returns all audiences related to the current document,
#   but adds a 'checked' flag for those which are checked.
##
sub audiences
{
    my $self = shift;
    my $cgix = cgi()->new;
    my $document = flo::Standard::current_document;
    
    my $checked = { map { $_ => 1 } $cgix->param ('audience') };
    my $audience_t = flo::Standard::table ('Audience');
    my @audiences = $audience_t->search->fetch_all;
    
    $_->{checked} = ($checked->{$_->id()}) ? 'checked' : undef for (@audiences);
    return wantarray ? @audiences : \@audiences;
}


##
# $self->http_post;
# -----------------
#   Reflect the changes on the database and redirects to
#   current document.
##
sub http_post
{
    my $self = shift;
    my $cgix = cgi()->new;
    my $current_document = flo::Standard::current_document();
    
    # let's set the document object attributes
    my $document = undef;
    my %param = (
	Title         => $cgix->param ('title'),
	Description   => $cgix->param ('description'),
	Keywords      => $cgix->param ('keywords'),
	Lang          => $cgix->param ('lang'),
	Rights        => $cgix->param ('rights'),
	Publisher     => $cgix->param ('publisher'),
	Template      => $current_document->popular_children_template(),
	Cache_Control => $cgix->param ('cache_control'),
       );
    
    my $document_table              = flo::Standard::table ('Document');
    $param{Date_Created}            = $self->_current_date;
    $param{Date_Last_Modified}      = $param{Date_Created};
    $param{Editor_Created_ID}       = flo::Standard::current_user()->id();
    $param{Editor_Last_Modified_ID} = $param{Editor_Created_ID};
    $param{Body}                    = '';
    $param{Parent_ID}               = $current_document->id;
    $param{Sort_By}                 = flo::Record::Document::SORT_TITLE();
    $param{Order_By}                = flo::Record::Document::ORDER_ASC();
    
    $document = new flo::Record::Document ( %param );
    $document || return $self->http_get();
    flo::RedirectManager->document_added ($document->path());
    
    $self->_set_audiences_from_cgi ($document);
    
    # add content if we passed any
    my $editor = _new flo::Editor (cgi => $cgix);
    $document->{Body} = $editor->generate_xml();
    $document->save();
    
    # redirect to content screen
    my $content_p = new flo::plugin::Admin::Content;
    my $path = $document->path();
    my $name = $content_p->name();
    local *flo::Plugin::path;
    *flo::Plugin::path = sub { $path . $name };
    
    print $cgix->redirect ($content_p->uri());
    return 'TERMINATE';
}


##
# $class->_current_date ($old_path, $new_path);
# ---------------------------------------------
#   Updates the redirect table in order to improve
#   document management.
##  
sub _current_date
{
    my $class = shift;
    
    # prefill date fields with current date
    my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime (time);
    $mon++;
    $year += 1900;
    
    if (length ($mon)  == 1) { $mon  = "0" . $mon  }
    if (length ($mday) == 1) { $mday = "0" . $mday }

    $mon  = 0 . $mon  if (length ($mon) < 2);
    $mday = 0 . $mday if (length ($mday) < 2);
    $hour = 0 . $hour if (length ($hour) < 2);
    $min  = 0 . $min  if (length ($min) < 2);
    $sec  = 0 . $sec  if (length ($sec) < 2);
    
    return "$year-$mon-$mday $hour:$min:$sec";
}


##
# $self->form_input ($name);
# --------------------------
#   Returns the default value to use for the form of
#   name $name.
##
sub form_input
{
    my $self   = shift;
    my $param  = shift;
    my $object = shift || current_document();
    if ($param =~ /^(title|name|keywords|description)$/)
    {
	my $cgi = cgi;
	return $cgi->param ($param);
    }
    else
    {
	return $self->SUPER::form_input ($param, $object);
    }
}


1;
