# -------------------------------------------------------------------
# flo::plugin::Login
# -------------------------------------------------------------------
# Author: Jean-Michel Hiver
# Copyright: (c) MKDoc Holdings Ltd, 2003
#
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# Description: flo::plugin::Logout sends the data
# that the current document outputs without caching it.
# -------------------------------------------------------------------
package flo::plugin::Login;
use strict;
use warnings;
use flo::Standard;
use base qw /flo::Plugin/;


sub run
{
    my $self = shift;
    
    my $cgi  = flo::Standard::cgi();
    my $path = $cgi->path_info();
    $path =~ s/\/\..*/\//;
    $cgi->path_info ($path);
    print $cgi->redirect ($cgi->self_url);
    
    return 'TERMINATE';
}


1;
