# -------------------------------------------------------------------------------------
# flo::plugin::Shop::Basket
# -------------------------------------------------------------------------------------
# Author : Jean-Michel Hiver.
# Copyright : (c) MKDoc Holdings Ltd, 2003
#
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
# This MKDoc plugin adds an item into someones' shopping basket.
# If the client sent a cookie, then this cookie is used to fetch the existing basket.
#
# Otherwise, this module creates a new shopping basket and sends a cookie to the
# client for future retrieval.
# -------------------------------------------------------------------------------------
package flo::plugin::Shop::Basket;
use strict;
use warnings;

use base qw /flo::Plugin/;


sub activate
{
    my $self = shift;
    my $session = MKDoc::Session->load() || return $self->SUPER::activate (@_);
    my $saveme  = 0;
    $session->{basket}  ||= do { $saveme = 1; new MKDoc::ECommerce::Basket() };
    $session->{country} ||= do { $saveme = 1; $ENV{ECOMMERCE_COUNTRY} || 'United Kingdom' };

    $session->save() if ($saveme);

    return $self->SUPER::activate (@_);
}


1;


__END__
