# -------------------------------------------------------------------------------------
# flo::plugin::Shop::Order
# -------------------------------------------------------------------------------------
# Author : Jean-Michel Hiver.
# Copyright : (c) MKDoc Holdings Ltd, 2003
#
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
# Order module which needs to be overriden / subclassed. It works as a standalone
# by connecting to itself, however it should be subclassed to be plugged into payment
# systems such as Worldpay / Paypal / etc. etc.
# -------------------------------------------------------------------------------------
package flo::plugin::Shop::Order;
use MKDoc::ECommerce::Order;
use flo::Standard;
use Petal::Mail;
use warnings;
use strict;

use base qw /flo::Plugin/;

our $CURRENT = shift;

sub activate
{
    my $self = shift;
    $flo::plugin::Shop::Order::CURRENT ||= $self;

    return unless ($self->SUPER::activate (@_));
    
    my $cgi = $self->cgi();
    my $id  = $cgi->param ('id') || return;
    $self->{order} = MKDoc::ECommerce::Order->load ($id) || return;
    
    return 1;
}


sub template_path
{
    my $self = shift;
    return 'shop/order';
}


##
# $self->http_get;
# ----------------
# Displays the form which lets the editor choose which audiences
# the current document relates to.
##
sub http_get
{
    my $self = shift;
    my $cgi  = flo::Standard::cgi();

    $cgi->param ('accept_me') && $self->{order}->accept();
    $cgi->param ('reject_me') && $self->{order}->reject();

    $self->render_http (
	self       => $self,
	__input__  => 'XML',
	__output__ => 'XHTML',
       );
    
    return 'TERMINATE';
}


sub http_post
{
    my $self = shift;
    return $self->http_get (@_);
}


sub order_uri
{
    my $self = shift;
    my $cgix = flo::Standard::cgi()->new();
    my $path_info = $cgix->path_info();
    $path_info =~ s/^.*\//\//;
    $cgix->path_info ($path_info);
    for ($cgix->param()) { $cgix->delete ($_) }
    $cgix->param ( id => $self->{order}->id() );
    return $cgix->self_url();
}


sub admin_user { return flo::Standard::table ('Editor')->get (1) }


1;


__END__
