# -------------------------------------------------------------------------------------
# flo::plugin::Sitemap
# -------------------------------------------------------------------------------------
# Author : Jean-Michel Hiver.
# Copyright : (c) MKDoc Holdings Ltd, 2003.
#
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------------------
package flo::plugin::Sitemap;
use flo::Standard;
use strict;
use base qw /flo::Plugin/;
use Encode;

our $Level = 0;


sub _name_default { '.sitemap.html' }


sub run
{
    my $self = shift;
    $| = 1;
    $self->render_http (
	self       => $self,
	root       => _structure (_results()),
	__input__  => 'XML',
	__output__ => 'XHTML',
       );
    return 'TERMINATE';
}


sub template_path { '/sitemap' }


sub _structure
{
    my $results = shift;
    local $Level = 0;
    
    my $res = _structure_recurse ($results);
    _reorder ($res->[0]);
    return shift (@{$res});
}


sub _reorder
{
    my $node = shift;
    return unless (defined $node->{Children} && scalar @{$node->{Children}});
    
    my $sort_on = $node->{Sort_By};
    my $desc    = $node->{Order_By};
    
    if ($sort_on eq 'Sibling_Position')
    {
	$node->{Children} = ($desc) ?
	[ sort { $b->{$sort_on} <=> $a->{$sort_on} } @{$node->{Children}} ] :
	[ sort { $a->{$sort_on} <=> $b->{$sort_on} } @{$node->{Children}} ];
    }
    else
    {
	$node->{Children} = ($desc) ?
	[ sort { $b->{$sort_on} cmp $a->{$sort_on} } @{$node->{Children}} ] :
	[ sort { $a->{$sort_on} cmp $b->{$sort_on} } @{$node->{Children}} ];
    }
    
    _reorder ($_) for (@{$node->{Children}});
}


sub _structure_recurse
{
    $Level++;

    my $flat = shift;
    scalar @{$flat} <= 1 and return [ shift @{$flat} ];

    my @res = shift @{$flat};
    while ( scalar @{$flat} )
    {   
        my $next_lvl = $flat->[0]->{Full_Path} =~ tr/\//\//;
        ($Level == $next_lvl) and do {
            push @res, shift @{$flat};
            next;
        };

        ($Level < $next_lvl)  and do {
            $res[-1]->{Children} = _structure_recurse ($flat);
        };

        ($Level > $next_lvl) and last;
    }

    $Level--;
    return [ @res ];
}


sub _results
{
    my $sql  = <<EOF;
SELECT Description, Full_Path, Title, Lang, Sort_By, Order_By, Date_Created, Date_Last_Modified, Sibling_Position
FROM Document
ORDER BY Full_Path ASC
EOF
    
    my $dbh = lib::sql::DBH->get();
    my $sth = $dbh->prepare_cached ($sql);
    $sth->execute();
    
    my @res = ();
    while (my $h = $sth->fetchrow_hashref())
    {
	Encode::_utf8_on ($h->{Description});
	Encode::_utf8_on ($h->{Title});
	
	# stick stuff in the sitemap only if it's showable
	my $o = bless $h, 'flo::Record::Document';
	push @res, $h if ($o->is_showable());
    }
    return \@res;
}


1;


__END__
