# -------------------------------------------------------------------------------------
# flo::plugin::URI_Normalize
# -------------------------------------------------------------------------------------
#
#       Author : Jean-Michel Hiver.
#    Copyright : (c) MKDoc Holdings Ltd, 2001
# 
#
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Description:
#
#      A plugin that is used to redirect HTTP requests that are not 'normal', i.e.
#      http://www.example.com//////////////////
#
# -------------------------------------------------------------------------------------
package flo::plugin::URI_Normalize;
use flo::RedirectManager;
use flo::Standard;
use strict;
use CGI::Util;

use vars qw /$cgi $rawPathInfo/;


##
# $class->main;
# -------------
#   Redirects the HTTP query, if needed
##
sub main
{
    my $class = shift;
    my $cgi   = flo::Standard::cgi();
    
    my $uri   = $cgi->self_url();
    my $uri2  = $uri;
    $uri2     =~ s/(?<!\:)\/+/\//g;

    $uri eq $uri2 and return;
    print $cgi->redirect ($uri2);
    return 'TERMINATE';
}


1;
