#!/usr/bin/perl
use strict;
use warnings;
use Cache::FileCache;
use LWP::Simple qw /get head $ua/;

use constant MAX_SIZE => 5242880;       # five megabytes

our $Cache;
our $URI;
our $Resp;


BEGIN {
  $ENV{MKDOC_DIR} || die 'MKDOC_DIR is not defined';
  unshift @INC, $ENV{MKDOC_DIR};
};

eval "use MKDoc::Config";
die $@ if (defined $@ and $@);

eval "use MKDoc::HTTP::Response";
die $@ if (defined $@ and $@);

$ua->max_size (MAX_SIZE);
for (site_list()) { process_directory ($_) }


sub site_list
{
    my $file = $ENV{MKDOC_DIR} . '/conf/httpd.conf';
    my @res  = ();
    open FP, "<$file" || die "Cannot read-open $file!";
    while (<FP>)
    {
	chomp();
        s/^Include\s+//    || next;
        s/\/httpd\.conf.*// || next;
        push @res, $_;
    }
    close FP;
    
    return sort @res;
}


sub process_directory
{
    $ENV{SITE_DIR} = shift;
    print "$ENV{SITE_DIR}\n";
    local $Cache = cache_object();
    foreach my $key ($Cache->get_keys()) {
        local $URI  = $key;
        local $Resp = new MKDoc::HTTP::Response ($Cache->get ($URI));
        $Resp->Status() !~ /^20/ and next;
	process_uri();
	$Cache->set ($URI, $Resp->GET());
    }
}


sub process_uri
{
    my ($content_type, $document_length, $modified_time, $expires, $server) = head ($URI);
    # http://www.intertwingly.net/blog/1142.html
    # for info on RSS content-type mess
    if (defined $content_type and (
	$content_type =~ /application\/rss\+xml/ or
	$content_type =~ /application\/xml/i     or
	$content_type =~ /text\/xml/i            or
	$content_type =~ /text\/html/i
       ) )
    {
	print "\t200 - $URI\n";
        $Resp->clear();
	$Resp->Status ('200 OK');
        $Resp->Content_Type ($content_type);
        $Resp->Last_Modified ($modified_time) unless (defined $modified_time);
        $Resp->Body (get ($URI));
    }
    else
    {
	print "\t503 - $URI\n";
        $Resp->Status ('503 Service Unavailable');
        $Resp->Retry_After (24 * 3600);
        $Resp->X_Retries (0);
    }
}


sub cache_object
{
    my %opt  = (
        cache_root => MKDoc::Config->DATA_DIR,
	namespace  => 'rss',
       );
    return new Cache::FileCache ( \%opt );
}


1;


__END__
