#!/usr/bin/perl
use strict;
use warnings;
use File::Spec;

my $cur_dir = shift || File::Spec->rel2abs ('.');

open FP, ">$cur_dir/mksetenv.sh" || die "Cannot create '$cur_dir/mksetenv.sh'";
print FP join "\n", (
    qq |export PERL5LIB=\$PERL5LIB:"$cur_dir"|,
    qq |export MKDOC_DIR="$cur_dir"|,
    qq |export PATH=\$PATH:"$cur_dir/tools":"$cur_dir/tools/cron"|
);
print FP "\n";
close FP;

open FP, ">>$cur_dir/conf/httpd.conf" || die "Cannot touch $cur_dir/conf/httpd.conf. Reason: $!";
print FP '';
close FP;

print "Successfully created $cur_dir/mksetenv.sh\n\n";
print "At this point you probably should add the following in your Apache httpd.conf file:\n\n";
print "# MKDoc - All Sites\n";
print "Include $cur_dir/conf/httpd.conf\n\n";


1;
