# -------------------------------------------------------------------------------------
# MKDoc::Handler::Authenticate
# -------------------------------------------------------------------------------------
# Author: Jean-Michel Hiver.
# Copyright: (c) MKDoc Holdings Ltd, 2003
#
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# Description: Authenticates against MKDoc's 'Editor' table
# -------------------------------------------------------------------------------------
package MKDoc::Handler::Authenticate;
use strict;
use warnings;
use Carp;
use flo::Standard;
use flo::Record::Editor;
use Apache::Constants qw/:common/;
use strict;
use Carp;


sub get_login
{
    my $r = Apache->request();
    my %args = $r->args();
    return $r->connection->user() || ''; 
}


sub get_password
{
    my $r = Apache->request();
    my ($res, $sent_pw) = $r->get_basic_auth_pw;
    my %args = $r->args();
    return $sent_pw || ''; 
}


sub handler
{
    my $r = shift;
    $::MKD_USER = undef;

    # checks that the user has sent a login / password pair
    my ($res, $sent_pw) = $r->get_basic_auth_pw;
    if ($res != OK)
    {
        $::MKD_USER = undef;
        return $res;
    }
    
    $sent_pw  = get_password(); 
    my $login = get_login(); 

    unless ($login and $sent_pw)
    {
        $r->note_basic_auth_failure;
        $::MKD_USER = undef;
        return AUTH_REQUIRED;
    }
   
    # fetches the user's password
    my $editor_t = flo::Standard::table ('Editor');
    my $editor   = $editor_t->get (Login => $login) || do {
        $r->note_basic_auth_failure;
        return AUTH_REQUIRED;
    };
    
    # if the user is disabled ========> []
    unless ($editor->is_enabled())
    {
        $::MKD_USER = undef;
        $r->note_basic_auth_failure;
        return AUTH_REQUIRED;
    }

    # compares the real password with the provided password
    if ($editor->password() eq $sent_pw)
    {
        $::MKD_USER = $editor;
        return OK;
    }
    else
    {
        $::MKD_USER = undef;
        $r->note_basic_auth_failure;
        return AUTH_REQUIRED;
    }
}


1;


__END__
