# -------------------------------------------------------------------------------------
# MKDoc::Handler::AuthenticateOpt
# -------------------------------------------------------------------------------------
# Author: Jean-Michel Hiver.
# Copyright: (c) MKDoc Holdings Ltd, 2003
#
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# Description: Authenticates against MKDoc's 'Editor' table
# -------------------------------------------------------------------------------------
package MKDoc::Handler::AuthenticateOpt;
use strict;
use warnings;
use Carp;
use flo::Standard;
use flo::Record::Editor;
use Apache::Constants qw/:common/;
use MIME::Base64;
use strict;
use Carp;


sub get_login
{
    my $r = Apache->request();
    
    my $authorization = $r->header_in ('Authorization') || return;
    $authorization =~ s/^Basic (.*)/$1/;
    $authorization = decode_base64 ($authorization);
    my ($user, $sent_pwd) = split (':', $authorization);
    return $user;
}


sub get_password
{
    my $r = Apache->request();
    my %headers = $r->headers_in();
    my $authorization = $r->header_in ('Authorization') || return;
    $authorization =~ s/^Basic (.*)/$1/;
    $authorization = decode_base64 ($authorization);
    my ($user, $sent_pwd) = split (':', $authorization);
    return $sent_pwd;
}


sub handler
{
    my $r = shift;
    $::MKD_USER = undef;
    
    my $sent_pw = get_password() || return OK;
    my $login   = get_login()    || return OK;
    
    return OK unless ($login and $sent_pw);
    
    # fetches the user's password
    my $editor_t = flo::Standard::table ('Editor');
    my $editor   = $editor_t->get (Login => $login) || return OK;
    
    # if the user is disabled ========> []
    unless ($editor->is_enabled())
    {
        $::MKD_USER = undef;
	return OK;
    }
    
    # compares the real password with the provided password
    if ($editor->password() eq $sent_pw)
    {
	$ENV{REMOTE_USER} = $editor->login();
        $::MKD_USER = $editor;
        return OK;
    }
    else
    {
        $::MKD_USER = undef;
	return OK;
    }
}


1;


__END__
