# -------------------------------------------------------------------------------------
# MKDoc::Handler::Initialize
# -------------------------------------------------------------------------------------
# Author: Jean-Michel Hiver.
# Copyright: (c) MKDoc Holdings Ltd, 2001
#
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# Description: Initializes MKDoc framework for subsequent handlers.
# -------------------------------------------------------------------------------------
package MKDoc::Handler::Initialize;
use strict;
use warnings;
use Petal;
use MKDoc::Config;
use Carp;
use lib::sql::DBH;
use lib::sql::Table;
use MKDoc::CGI;

use CGI qw(-compile :all);


sub sillyness
{
    $::MKD_IS_INIT,
}


sub handler
{
    $CGI::USE_PARAM_SEMICOLONS = 1;
    + lib::sql::DBH->disconnect;
    
    clean_globals();

    $ENV{USE_CGI} and do {
        open FP, "<$ENV{USE_CGI}" or die "Cannot read-open $ENV{USE_CGI}";
        my $data = join '', <FP>;
        close FP;

        eval $data;
        die $@ if ($@);
    };
 
    $Petal::DECODE_CHARSET = 'utf8';
    $Petal::ENCODE_CHARSET = 'utf8';    
    $Petal::BASE_DIR = undef;
    @Petal::BASE_DIR = (MKDoc::Config->TEMPLATE_DIR2, MKDoc::Config->TEMPLATE_DIR);
    
    # loads database table schemas
    + lib::sql::Table->load_state (MKDoc::Config->SITE_DIR .'/su');
    
    $::MKD_IS_INIT = 1;
    return 1;
}


# reinitializes global variables to their default values
sub clean_globals
{
    foreach my $key (keys %::)
    {
	if ($key =~ /^MKD_/)
	{
	    my $val = $ {$::{$key}};
	    next unless (defined $val);            # already reinitialized...
	    next if (ref $val eq 'MKDoc::Config'); # handled by process()
	    
	    # if $val is a hashref, then reinitialize
	    # to an empty hashref
	    if (ref $val eq 'HASH')
	    {
		$ {$::{$key}} = {};
		next;
	    }
	    
	    # if $val if an arrayref, then reinitialize
	    # to an empty arrayref
	    if (ref $val eq 'ARRAY')
	    {
		$ {$::{$key}} = [];
		next;
	    }
	    
	    # otherwise, just undef the variable
	    $ {$::{$key}} = undef;
	}
    }
}


1;


__END__
