package MKDoc::MailForm;
use warnings;
use strict;
use Petal::Mail;
use MKDoc::Ouch;
use Mail::CheckUser;
use Time::ParseDate;


$Mail::CheckUser::Timeout = 5;
$Mail::CheckUser::Treat_Timeout_As_Fail = undef;
$Mail::CheckUser::Treat_Full_As_Fail = undef;

our $Err;


##
# $class->new();
# --------------
#    cgi  => $cgi_object,
##
sub new
{
    my $class = shift;
    return bless { @_ }, $class;
}


sub cgi { shift->{cgi} }


sub mailto
{
    my $self = shift;
    return $self->{mailto} ||
           flo::Standard::table ('Editor')->get (1)->email();
}


sub fields 
{
    my $self = shift;
    my $cgi  = $self->cgi();
    my @res  = ();

    for ($cgi->param())
    {
        /^info\d\d\d-.*-(field|alias)$/ and do { push @res, $_ };
    }

    return sort @res;
}


sub process
{
    my $self  = shift;
    local ($Err) = 0;

    my @fields = $self->fields();
    my $count = scalar @fields;

    $count || return;

    local $Err = undef;
    $self->set_mandatory_cgi_fields();
    my @values = $self->extract_and_validate_values();

    $Err && return;

    my %values = @values;

    my @loop = ();
    while (@values)
    {
        my $label = shift (@values);
        my $value = shift (@values);
        push @loop, {
            label => $label,
            value => $value,
        };
    }

    $self->{loop} = \@loop;

    my $mail = new Petal::Mail ('mailform.xml');
    $mail->send (
        self    => $self,
        email   => $values{email},
        subject => $values{subject},
    );
}


sub set_mandatory_cgi_fields
{
    my $self = shift;
    my $cgi  = $self->cgi();

    # set up mandatory email
    defined $cgi->param ('info000-email-field') ||
    defined $cgi->param ('info000-email-alias') || do {
        $cgi->param ('info000-email-field', '');
    };

    $cgi->param ('info000-email-validate' => 'email');
    $cgi->param ('info000-email-error') || do {
        $cgi->param ('info000-email-error' => 'Invalid Address');
    };

    # set up mandatory subject
    defined $cgi->param ('info000-subject-field') ||
    defined $cgi->param ('info000-subject-alias') || do {
        $cgi->param ('info000-subject-field', '');
    };

    $cgi->param ('info000-subject-validate' => 'text');
    $cgi->param ('info000-subject-error') || do {
        $cgi->param ('info000-subject-error' => 'No Subject');
    };

    return;
}


sub extract_and_validate_values 
{
    my $self   = shift;
    my $cgi    = $self->cgi();
    my @fields = $self->fields();
    my @res    = ();

    foreach my $field (@fields)
    {
        my $value = $cgi->param ($field);
        $value    = $cgi->param ($value) if ($field =~ /alias$/);

        my $validate_field_name = $field;
        $validate_field_name =~ s/-(field|alias)$/-validate/;

        my $error_field_name = $field;
        $error_field_name =~ s/-(field|alias)$/-error/;

        my $validate_value  = $cgi->param ($validate_field_name);
        $validate_value && do {
            my $error_value     = $cgi->param ($error_field_name)    || 'BUG: NO ERROR MESSAGE?';

            my $validate_method = "validate_$validate_value";
            $validate_value && $self->can ($validate_method) && 
            $self->$validate_method ($value) || do {
                $Err = 1;
                my $err = new MKDoc::Ouch 'mailform/error';
                $err->{message} = $error_value;
            };
        };
        
        my $email_label = $field;
        $email_label    =~ s/^info\d\d\d-//;
        $email_label    =~ s/-(field|alias)$//;
        push @res, ($email_label => $value);
    }

    return wantarray ? @res : \@res;
}


sub validate_email
{
    my $self = shift;
    my $data = shift;
    $data || return;
    return Mail::CheckUser::check_email ($data);
}


sub validate_text
{
    my $self = shift;
    my $data = shift || '';
    chomp ($data);
    $data =~ s/^\s+//;
    $data =~ s/\s+$//;

    my $res  = (defined $data and $data ne '') ? 1 : 0;
    return $res;
}


sub validate_date
{
    my $self = shift;
    return parsedate (shift);
}


sub validate_numerical
{
    my $self = shift;
    local $_ = shift;
    if (/\D/) { return 1 };
    if (/^\d+$/) { return 1 };
    if (/^-?\d+$/) { return 1 };
    if (/^[+-]?\d+$/) { return 1 };
    if (/^-?\d+\.?\d*$/) { return 1 };
    if (/^-?(?:\d+(?:\.\d*)?│\.\d+)$/) { return 1 };
    if (/^([+-]?)(?=\d│\.\d)\d*(\.\d*)?([Ee]([+-]?\d+))?$/) { return 1 };
    return;
}


1;


__END__
