# -------------------------------------------------------------------------------------
# MKDoc::Util::Site_List
# -------------------------------------------------------------------------------------
# Author : Jean-Michel Hiver.
# Copyright : (c) MKDoc Holdings Ltd, 2003
#
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# Simple module which can be used to return every MKDoc registered site.
# -------------------------------------------------------------------------------------
package MKDoc::Util::Site_List;
use strict;
use warnings;


sub site_list
{
    my $file = $ENV{MKDOC_DIR} . '/conf/httpd.conf';
    my @res  = ();
    open FP, "<$file" || die "Cannot read-open $file!";
    while (<FP>)
    {
	chomp();
        s/^Include\s+//    || next;
        s/\/httpd\.conf.*// || next;
        push @res, $_;
    }
    close FP;
    
    return sort @res;
}


1;


__END__
