# -------------------------------------------------------------------------------------
# flo::Record::Contributor
# -------------------------------------------------------------------------------------
# Author : Jean-Michel Hiver.
# Copyright : (c) MKDoc Holdings Ltd, 2003.
#
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------------------
package flo::Record::Contributor;
use flo::Standard;
use 5.008_000;
use utf8;
use strict;
use Carp;


##
# $self->editor_id;
# -----------------
#   getter for the 'Editor_ID' attribute.
##
sub editor_id
{
    my $self = shift;
    return $self->{Editor_ID};
}


##
# $self->set_editor_id ($editor_id);
# ----------------------------------
#   $editor_id - The ID of the editor to set.
#
#   Setter for the 'Editor_ID' attribute.
##
sub set_editor_id
{
    my $self = shift;
    return $self->{Editor_ID};
}


##
# $self->editor;
# --------------
#   Getter for the 'flo::Record::Editor' associated with this object.
##
sub editor
{
    my $self = shift;
    my $editor_table = flo::Standard::table ('Editor');
    return $editor_table->get ($self->editor_id);
}


##
# $self->set_editor ($editor);
# ----------------------------
#   $editor - editor object to extract the ID from
#
#   Setter for the 'Editor_ID' attribute via the 'flo::Record::Editor' object.
##
sub set_editor
{
    my $self = shift;
    my $editor = shift;
    return $self->set_editor_id ($editor->id);
}


##
# $self->document_id;
# -------------------
#   Getter for the 'Document_ID' attribute.
##
sub document_id
{
    my $self = shift;
    return $self->{Document_ID};
}


##
# $self->set_document_id ($document_id);
# --------------------------------------
#   $document_id - The ID of the editor to set.
#
#   Setter for the 'Document_ID' attribute.
##
sub set_document_id
{
    my $self = shift;
    $self->{Document_ID} = shift;
}


##
# $self->document;
# ----------------
#   Returns the Document object which is related to that Contributor record.
##
sub document
{
    my $self = shift;
    my $document_table = flo::Standard::table ('Document');
    return $document_table->get ($self->document_id);
}


##
# $self->set_document ($document);
# --------------------------------
#   $document - document object to extract the ID from
#
#   Setter for the 'Document_ID' attribute via the 'flo::Record::Document' object.
##
sub set_document
{
    my $self = shift;
    my $document = shift;
    return $self->set_document_id ($document->id);
}


1;
