# -------------------------------------------------------------------------------------
# flo::editor::Mixin::compute_name
# -------------------------------------------------------------------------------------
#
#       Author : Jean-Michel Hiver.
#    Copyright : (c) MKDoc Holdings Ltd, 2001
#
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
#    Description:
#
#      Mixin to compute random directory names for file attachments, images, etc.
#
# -------------------------------------------------------------------------------------
package flo::editor::Mixin::compute_name;
use strict;


##
# $class->compute_name;
# ---------------------
#   Static method that computes a random 10 digit directory name
##
sub compute_name
{
    my $class = shift;
    my @char = 0..9;
    my $size = scalar (@char);

    return join '', map { $char[int rand $size] } 1..10;
}


1;
