# -------------------------------------------------------------------------------------
# flo::editor::Mixin::upload_file
# -------------------------------------------------------------------------------------
#
#       Author : Jean-Michel Hiver.
#    Copyright : (c) MKDoc Holdings Ltd, 2001
#
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
#    Description:
#
#      Mixin to make file, images, photos, etc... names look better
#
# -------------------------------------------------------------------------------------
package flo::editor::Mixin::upload_file;
use MKDoc::Config;
use flo::Standard;
use strict;
use Carp;


##
# $class->upload_file ($key, $dir, $file, $fname);
# ------------------------------------------------
#   Static methos which uploads a file. It takes the following parameters:
#
#   $key - must match a configuration key in the MKDoc::Config object
#   returned by the flo::Standard::general_config() function
#
#   $dir - directory which needs to be created inside the base directory
#   matching $key
#
#   $file - file name to write to inside $dir
#
#   $fname - a file hande that holds the data to upload
#
#   Returns TRUE on success, FALSE otherwise.
##
sub upload_file
{
    my $class = shift;
    my $key   = shift;
    my $dir   = shift;
    my $file  = shift;
    my $fname = shift;
    
    # protects against silly long filenames and opera upload bug
    if (length ($file) > 255)
    {
	carp ('Cannot upload file \'' . (substr $file, 0, 16) . '...\' : filename too long');
	return;
    }
  
    my $base_dir = ($key eq 'image_disk_path') ? MKDoc::Config->IMAGE_DISK_PATH : MKDoc::Config->FILE_DISK_PATH;
    unless (-e "$base_dir/$dir")
    {
	mkdir "$base_dir/$dir"
	    or confess "Cannot create directory $dir";
    }
    
    open (FP, ">$base_dir/$dir/$file")
	or confess "Cannot write-open $dir/$file";
    my $buffer;
    no strict;
    while ( read ($fname, $buffer, 1024)) { print FP $buffer }
    use strict;
    close FP;
    
    return 1;
}


1;
