# -------------------------------------------------------------------------------------
# flo::plugin::Account::PreferenceSpy
# -------------------------------------------------------------------------------------
# Author : Steve Purkis <spurkis@mkdoc.com>
# Copyright : (c) 2003, MKDoc Holdings Ltd.
#
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------------------
package flo::plugin::Account::PreferenceSpy;
use base qw /flo::plugin::Account::Preferences/;
use Petal::Mail;
use warnings;
use strict;


sub name
{
    return flo::plugin::Account::Preferences->name();
}


sub http_post
{
    my $self = shift;
    my $ret  = $self->SUPER::http_post (@_);

    my @res  = map {
        my $name  = $_->name();
        my $label = $_->label();
        my $value = $self->preferences()->audience_preference ($name);
        $value = 'dislike'   if ( $value eq '-1'  );
        $value = 'like'      if ( $value eq '1'   );
        $value = 'dont_mind' if ( $value eq '0E0' );
        
        {
            name  => $name,
            label => $label,
            value => $value,
        };
    } $self->preferences()->audiences();

    my $mail = new Petal::Mail ('detailspy.xml');
    $mail->send (loop => \@res);

    return $ret;
}


1;


__END__
