# -------------------------------------------------------------------------------------
# flo::plugin::Admin::Delete
# -------------------------------------------------------------------------------------
# Author : Jean-Michel Hiver
# Copyright : (c) MKDoc Holdings Ltd, 2003
#
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
# Lets an editor delete the current document. Redirects to the parent document.
# -------------------------------------------------------------------------------------
package flo::plugin::Admin::Delete;
use MKDoc::Config;
use MKDoc::Error;
use Encode;
use flo::Standard;
use strict;
use warnings;
use 5.008_000;
use Carp;

use base qw /flo::Plugin/;

sub template_path { 'admin/delete' }


##
# $self->activate;
# ----------------
# Returns TRUE if this plugin can be activated, FALSE
# otherwise.
##
sub activate
{
    my $self = shift;
    return unless ($self->SUPER::activate (@_));
    my $current_document = flo::Standard::current_document();
    return if ($current_document->is_root());
    my @children = $current_document->children();
    return if (scalar @children);
    return $current_document->Can_Admin;
}


sub http_get
{
    my $self = shift;
    my $doc  = flo::Standard::current_document();
    $self->render_http (
	self       => $self,
	__input__  => 'XML',
	__output__ => 'XHTML',
       );
    
    return 'TERMINATE';
}


sub http_post
{
    my $self  = shift;
    my $cgix  = flo::Standard::cgi()->new();
    my $to    = $cgix->param ('to');
    my $doc_t = flo::Standard::table ('Document');
    my $lang  = flo::Standard::current_document()->language();
    
    defined $to and $to or do {
	new MKDoc::Ouch 'document/delete/id';
	return $self->http_get();
    };
    
    my $document_t = flo::Standard::table ('Document');
    $document_t->get ($to) or do {
	new MKDoc::Ouch 'document/delete/id';
	return $self->http_get();
    };
    
    $self->is_ie_bug() and do {
	$self->redirect();
	return 'TERMINATE';
    };
    
    $self->delete();
    $cgix->path_info ($self->target()->path());
    $cgix->delete ($cgix->param());
    print $cgix->redirect ($cgix->self_url());
    return 'TERMINATE';
}


# returns TRUE if i.e. is sending a buggy POST,
# FALSE otherwise.
#
# 192.168.1.80 - - [19/Jul/2001:13:14:32 +0100] \
# "GET /ccccccccccc/?admin=document_delete;redirect_id=8 HTTP/1.1" 302 5
# 192.168.1.80 - - [19/Jul/2001:13:14:32 +0100] \
# "GET /aaaaa/bbbbb/?admin=document_delete;redirect_id=8 HTTP/1.1" 302 5
sub is_ie_bug
{
    my $self = shift;
    my $cgix = flo::Standard::cgi()->new();
    my $to   = $cgix->param ('to');
    
    my $document_t = flo::Standard::table ('Document');
    my $source = flo::Standard::current_document();
    my $target = $document_t->get ($to);
    return $source->equals ($target);
}


sub target
{
    my $self = shift;
    my $cgi  = flo::Standard::cgi();
    my $to   = $cgi->param ('to');
    
    my $document_t = flo::Standard::table ('Document');
    return $document_t->get ($to) || do {
	warn "Cannot find document with id $to";
	undef;
    };
}


sub delete
{
    my $self   = shift;
    my $target = $self->target();
    my $source = flo::Standard::current_document();
    $source->delete ($target);
}


sub is_document_leaf
{
    my $self = shift;
    my $doc  = flo::Standard::current_document();
    my @kids = $doc->children();
    return not scalar @kids;
}


sub is_document_root
{
    my $self = shift;
    my $doc  = flo::Standard::current_document();
    return $doc->is_root();
}


sub redirectable_document_list
{
    my $self = shift;
    my $document_t = flo::Standard::table ('Document');
    my $document   = flo::Standard::current_document();
    my $dbh = lib::sql::DBH->get();
    my $sth = $dbh->prepare_cached ('SELECT * FROM Document WHERE ID != ? ORDER BY (Full_Path)');
    $sth->execute ($document->id());
    my @res = ();
    while (my $h = $sth->fetchrow_hashref())
    {
	Encode::_utf8_on ($h->{Description});
	Encode::_utf8_on ($h->{Title});
	push @res, $h;
    }
    return wantarray ? @res : \@res;
}


1;
