package flo::plugin::Admin::UserModify;
use strict;
use warnings;
use flo::Standard;
use flo::Record::Editor;
use base qw /flo::Plugin/;


sub activate
{
    my $self = shift;
    $self->SUPER::activate (@_) || return;
    $self->SUPER::user()->id() == 1    || return;
    
    my $cgi = $self->cgi();
    my $user_edit_id = $cgi->param ('id') || return;
    my $editor_t = flo::Standard::table ('Editor');
    $self->{user_edit} = $editor_t->get ($user_edit_id) || return;
    
    return 1;
}


sub user_edit
{
    my $self = shift;
    return $self->{user_edit};
}


sub template_path { 'admin/user_modify' }


sub http_get
{
    my $self = shift;
    my $cgi  = flo::Standard::cgi();
    my $user_edit = $self->user_edit();
    $cgi->param ('base_documents', map { $_->id() } $user_edit->base_documents());
    $cgi->param ('login', $user_edit->login());
    $cgi->param ('first_name', $user_edit->first_name());
    $cgi->param ('family_name', $user_edit->family_name());
    $cgi->param ('email', $user_edit->email());
    $cgi->param ('password', $user_edit->password());
    $cgi->param ('disabled', $user_edit->enabled() ? 0 : 1);
    $self->render_http (
	self => $self,
	__output__ => 'XHTML',
       );
    return 'TERMINATE';
}


sub http_post
{
    my $self = shift;
    my $cgi  = flo::Standard::cgi();
    my $user_edit = $self->user_edit();
    $user_edit->id() == 1 and do {
        $cgi->delete ('base_documents');
        $cgi->delete ('disabled');
    };
    
    $user_edit->set_password    ($cgi->param ('password'));
    $user_edit->set_email       ($cgi->param ('email'));
    $user_edit->set_first_name  ($cgi->param ('first_name'));
    $user_edit->set_family_name ($cgi->param ('family_name'));
    $user_edit->set_enabled     (not $cgi->param ('disabled'));
    $user_edit->validate() || return $self->http_get();

    $user_edit->save();
    $self->insert_base_document ($user_edit->id());
    $self->{ok} = 1;
    return $self->http_get();
}



sub insert_base_document
{
    my $self = shift;
    my $id = shift;
    my $cgi = flo::Standard::cgi();
    my @base_documents = map { 0 + $_ > 0 ? $_ : () } $cgi->param ('base_documents');
    
    my $base_document_t = flo::Standard::table ('Base_Document');
    $base_document_t->delete (Editor_ID => $id);
    $base_document_t->insert (Editor_ID => $id, Document_ID => $_) for (@base_documents);
}


sub documents
{
    my $self = shift;
    my $document_t = flo::Standard::table ('Document');
    my @res = $document_t->select (
	cols => '*',
	sort => [ 'Full_Path' ],
	desc => 0,
       )->fetch_all();

    return wantarray ? @res : \@res;
}


sub is_selected
{
    my $self = shift;
    my $document = shift;
    my $id = $document->id();
    my $cgi = flo::Standard::cgi();
    my @base_documents = $cgi->param ('base_documents');
    $_ == $id and return 1 for (@base_documents);
    return;
}


1;
