# -------------------------------------------------------------------------------------
# flo::plugin::Error
# -------------------------------------------------------------------------------------
#
#       Author : Jean-Michel Hiver.
#    Copyright : (c) MKDoc Holdings Ltd, 2003
# 
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
#    Description:
#
#      This module is invoked when the query could not be processed, and returns
#      a 404 page
#
# -------------------------------------------------------------------------------------
package flo::plugin::Error;
use base qw /flo::Plugin/;
use strict;
use warnings;


sub activate
{
    1;
}


sub run
{
    my $self = shift;
    
    #    my $lang = $ENV{HTTP_ACCEPT_LANGUAGE};
    #    if (defined $lang and $lang)
    #    {
    #	$lang =~ s/^\s*//;
    #	$lang =~ s/,.*$//;
    #    }
    #    else
    #    {
    #	$lang = 'en';
    #    }
    
    my $status = $self->status();
    # my $code = $self->code();
    
    #my $template = new Petal
    #    file => "error/$code",
	#lang => $lang;
    
    # my $data = $template->process ( self => $self );
    # use bytes;
    
    print <<EOF;
Status: $status
Content-Type: text/html; charset=UTF-8

$@
EOF
    return 'TERMINATE';
}


sub status
{
    my $self = shift;
    my $status = $self->{status} || '404 Not Found';
    return $status;
}


sub code
{
    my $self = shift;
    my $status = $self->status();
    my ($code) = $status =~ /^(\d+)/;
    return $code;
}


1;
