# -------------------------------------------------------------------------------------
# flo::plugin::Robots
# -------------------------------------------------------------------------------------
#
#       Author : Alexandre Girard (agirard@popmail.com)
#    Copyright : (c) MKDoc Holdings Ltd, 2001
#
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
#    Description:
#
#      A plugin that is used to avoid search engine browsing sitemap and
#      search engine
#
# -------------------------------------------------------------------------------------
package flo::plugin::Robots;
use flo::Standard;
use base qw /flo::Plugin/;
use warnings;
use strict;

our @FORBIDDEN = ();


sub register
{
    my $class = shift;
    my $stuff = shift;
    push @FORBIDDEN, $stuff->name();
}


sub name { 'robots.txt' }


sub http_get
{
    ($ENV{REQUEST_METHOD} =~ /^GET$/) and do {
	print "Content-Type: text/plain; charset=US-ASCII\n\n";
	return 'TERMINATE';
    };
    
    my $sql = 'SELECT Full_Path FROM Document';
    my $dbh = lib::sql::DBH->get;
    my $sth = $dbh->prepare_cached ($sql);
    $sth->execute();
    
    print "User-agent: *\n";
    while (my $arryref = $sth->fetchrow_arrayref)
    {
	print $arryref->[0] . $_ . "\n" for (@FORBIDDEN);
    }
    
    return 'TERMINATE';
}


1;


__END__
