# -------------------------------------------------------------------------------------
# flo::plugin::Shop::Basket::Help
# -------------------------------------------------------------------------------------
# Author : Jean-Michel Hiver.
# Copyright : (c) MKDoc Holdings Ltd, 2003
#
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
# In the unfortunate event where a user doesn't support cookies or isn't logged in,
# displays some help and hope they don't go away.
# -------------------------------------------------------------------------------------
package flo::plugin::Shop::Basket::Help;
use strict;
use warnings;
use MKDoc::Ouch;
use flo::Standard;

use base qw /flo::Plugin/;


##
# $self->template_path();
# -----------------------
# Returns the template path in which to find the shopping
# basket templates.
##
sub template_path
{
    my $self = shift;
    return 'shop/basket/help';
}


##
# $self->http_get;
# ----------------
# Displays the form which lets the editor choose which audiences
# the current document relates to.
##
sub http_get
{
    my $self     = shift;
    $self->render_http (
	self       => $self,
	__input__  => 'XML',
	__output__ => 'XHTML',
       );
    
    return 'TERMINATE';
}


1;
