#!/usr/bin/perl
use strict;
use warnings;
use MKDoc;

# make sure SITE_DIR is set since MKDoc->init needs it
die "SITE_DIR isn't set.  Please source mksetenv.sh from an installed MKDoc site ".
  "and try again.\n" 
  unless $ENV{SITE_DIR};

# initialize MKDoc, needed for database connection
MKDoc->init;

print "Creating the Document_TimeRange table...\n";
my $dbh = lib::sql::DBH->get();
$dbh->do(<<END);
    CREATE TABLE Document_TimeRange (
      ID int(11)          NOT NULL auto_increment,
      Document_ID int(11) NOT NULL default '0',
      FromDate datetime   NOT NULL default '0000-00-00 00:00:00',
      ToDate datetime     NOT NULL default '0000-00-00 00:00:00',
      PRIMARY KEY   (ID),
      KEY DocIndex  (Document_ID),
      KEY FromIndex (FromDate),
      KEY ToIndex   (ToDate)
    ) TYPE=MyISAM
END
