#!/usr/bin/perl

# IMPORTANT IMPORTANT IMPORTANT IMPORTANT IMPORTANT
# this is a custom install script for installing MKDoc
# in a gossamer-threads hosting environment.

# use required modules, just to make sure we have them
use CGI;
use XML::RSS;
use Petal;
use Text::Unidecode;
use DBI;
use DBD::mysql;
use Mail::IMAPClient;
use MIME::Base64;
use Date::Manip;
use Time::ParseDate;
use Cache::Cache;
use File::Copy;

# use modules required for install
use MKDoc::Site::ConfigWriter::MKDocRegistrer;
use MKDoc::Site::ConfigWriter::Httpd_Conf;
use MKDoc::Site::Deploy::DB;
use MKDoc::Site::ConfigUI;
use MKDoc::Site::Config;
use warnings;
use strict;

# load scott's stuff
use GPanel::MySQL;
use GPanel::Domain;
use GPanel::User qw/ACCESS_ALL/;
use GPanel::Config;


# override some stuff
*MKDoc::Site::ConfigUI::menu_main = sub
{
    my $self = shift;

    $self->clear_screen();    
    $self->print_screen (
	"1 - Organization details",
	"2 - First user details\n\n",
       );
    
    $self->print_screen (
	"S - Save Makefile.PL and exit",
	"X - eXit without without saving",
	"",
	"Input Choice: "
       );
    
    my $line = $self->get_stdin_line();
    
    if    ($line eq '1') { $self->{state} = 'menu_organization' }
    elsif ($line eq '2') { $self->{state} = 'menu_user'         }
    elsif ($line eq 'x' or $line eq 'X') { $self->{state} = 'exit_without_install' }
    elsif ($line eq 's' or $line eq 'S') { $self->{state} = 'check_params'         }
};


*MKDoc::Site::Deploy::DB::populate_tables = sub
{
    my $self   = shift;
    my $config = $self->config;

    $self->say("  +  populating tables from config:");

    my $editor_table        = lib::sql::Table->table('Editor');
    my $document_table      = lib::sql::Table->table('Document');
    my $base_document_table = lib::sql::Table->table('Base_Document');
    
    my $amount = int (rand (2)) + 3;
    my @rand = qw /a i u e o
		   ka ki ku ke ko
		   sa shi su se so
		   ta tchi tsu te to
		   na ni nu ne no
		   ha hi fu he ho
		   ma mi mu me mo
		   ya yu yo
		   la li lu le lo
		   wa wo/;
    
    $::ADMIN_PASSWD ||= join '', map { $rand[int rand (scalar @rand)] } 1..$amount;
    
    $self->say("\t  +  adding 'admin' user\n");
    $editor_table
      ->insert(
	       Login       => 'admin',
	       Password    => $::ADMIN_PASSWD,
	       Email       => $config->{ORGANIZATION_EMAIL},
	       First_Name  => '',
	       Family_Name => $config->{ORGANIZATION_NAME},
	       Disabled    => 0,
	      );
    
    $self->say("\t  +  adding '$config->{USER_LOGIN}' user\n");
    $editor_table
      ->insert(
	       Login       => $config->{USER_LOGIN},
	       Password    => $config->{USER_PASS},
	       Email       => $config->{USER_EMAIL},
	       First_Name  => $config->{USER_FIRST_NAME},
	       Family_Name => $config->{USER_LAST_NAME},
	       Disabled    => 0,
	      );
    # assume auto-inc ID's, we inserted 2 editors:
    my $editor_id = 2;

    $self->say("\t  +  creating root document owned by $config->{USER_LOGIN}\n");
    $document_table
      ->insert(
	       Template                => 'default',
	       Cache_Control           => 10,    # what's this mean?
	       Description             => 'enter a description here',
	       Keywords                => 'enter keywords here',
	       Date_Created            => MKDoc::Site::Deploy::DB::current_date(),
	       Date_Last_Modified      => MKDoc::Site::Deploy::DB::current_date(),
	       Editor_Created_ID       => $editor_id,
	       Editor_Last_Modified_ID => $editor_id,
	       Name                    => '',
	       Title                   => 'Root document',
	       Lang                    => 'en',
	       Sort_By                 => 'Title',
	       Order_By                => 0,     # what's this mean?
	      );
    # assume auto-inc ID's, we inserted 1 doc:
    my $doc_id = 1;

    $self->say("\t  +  setting $config->{USER_LOGIN}'s base document\n");
    $base_document_table
      ->insert(
	       Editor_ID   => $editor_id,
	       Document_ID => $doc_id,
	      );

    return 1;
};


{
    my $amount = int (rand (2)) + 3;
    my @rand = qw /a i u e o
		   ka ki ku ke ko
		   sa shi su se so
		   ta tchi tsu te to
		   na ni nu ne no
		   ha hi fu he ho
		   ma mi mu me mo
		   ya yu yo
		   la li lu le lo
		   wa wo/;
    
    $::ADMIN_PASSWD = join '', map { $rand[int rand (scalar @rand)] } 1..$amount;
}


init GPanel::Config;


my $user_name = $ENV{SITE_USER};
$MKDoc::Site::Config::CONFIG = do {
    my $config = MKDoc::Site::ConfigUI->new ( MKDoc::Site::ConfigUI->_new_attributes );

    my $inc = 1;
    if (getpwnam($user_name)) {
        my $user = new GPanel::User($user_name);
        my $domains = GPanel::Domain->list($user);
        $inc = @$domains;
    }

    my $domain_name;
    $domain_name = $1 if $config->{site_dir} =~ m{/?([^/]+)/?$};
    my $dbname = lc($domain_name);
    $dbname =~ s/\W+/_/g;
    
    $config->{database_user} = $user_name . $inc;
    $config->{database_name} = $dbname;
    $config->{database_host} = 'localhost';
    $config->run();
    $config->is_ok() || do {
	print "Exit.\n";
	exit;
    };
    $config;
};



my $user;
if (getpwnam($user_name)) {
    $user = new GPanel::User($user_name);
}
else {
    print "Creating User\n";
    my $email = $MKDoc::Site::Config::CONFIG->{organization_email};
    $user = GPanel::User->add(
        login       => $user_name,
        password    => '!',
        skel        => 'ssh',
        email       => $email,
        access_type => ACCESS_ALL,
    ) or die "Error adding user $user_name: $GPanel::User::error";

    # need to populate the crontab with search indexer and rss fetcher
    require GPanel::Crontab;
    my $c = GPanel::Crontab->new(user => $user_name);
    my $rand_60 = int (rand (60));
    my $rand_20 = int (rand (20));
    my $rand_abc = join ",", (0 + $rand_20), (20 + $rand_20), (40 + $rand_20);
    $c->add_raw->value("0 6 * * * crontab -l > \$HOME/crontab");
    $c->add_raw->value("$rand_60 * * * * source $ENV{MKDOC_DIR}/mksetenv.sh && 010..indexer.pl 5400 >/dev/null");
    $c->add_raw->value("$rand_abc * * * * source $ENV{MKDOC_DIR}/mksetenv.sh && 030..rss_troubleshooter.pl 36 >/dev/null");
    $c->add_raw->value("$rand_60 11 * * * source $ENV{MKDOC_DIR}/mksetenv.sh && 031..rss_routine.pl");
    $c->write;
}


my $home = (getpwnam($user_name))[7];
chdir $home;

print "Creating Domain\n";
my $ip = '69.28.204.54';
my $domain_name;
$domain_name = $1 if $MKDoc::Site::Config::CONFIG->{site_dir} =~ m{/?([^/]+)/?$};
$domain_name or die "could not get site name";

my $domain = GPanel::Domain->new($domain_name);
unless ($domain) {
    $domain = GPanel::Domain->add(
        user   => $user,
        domain => $domain_name,
        ip     => $ip,
    );
}
$domain or diag ("Error: $GPanel::Domain::error");

defined $domain or do {
    die "Cannot create \$domain:
user   => $user,
domain => $domain_name,
ip     => $ip";
};


print "Creating Newsletter cronjobs\n";
my $config_site_dir = $MKDoc::Site::Config::CONFIG->{site_dir};

require GPanel::Crontab;
my $c = GPanel::Crontab->new(user => $user_name);
my $rand_60 = int (rand (60));
$c->add_raw->value("\n$rand_60 8 * * *   source $config_site_dir/mksetenv.sh && 020..newsletter.pl day");
$c->add_raw->value("$rand_60 8 * * mon source $config_site_dir/mksetenv.sh && 020..newsletter.pl week");
$c->add_raw->value("$rand_60 8 1 * *   source $config_site_dir/mksetenv.sh && 020..newsletter.pl month");
$c->write;


unless ($MKDoc::Site::Config::CONFIG->{imap_user}) {
    $MKDoc::Site::Config::CONFIG->{imap_user} = $MKDoc::Site::Config::CONFIG->{database_user};
    $MKDoc::Site::Config::CONFIG->{imap_host} = 'localhost';
    $MKDoc::Site::Config::CONFIG->{imap_pass} = $::ADMIN_PASSWD;
}
$domain->enable_mail(1, join '', map { chr(ord('a') + int(rand 26)) } 1 .. 10);
my $v = new Mail::Vail::Domain($domain->name);
Mail::Vail::User->add(
    name     => $MKDoc::Site::Config::CONFIG->{database_user},
    passwd   => $::ADMIN_PASSWD,
    realname => "imap $domain_name",
    domain   => $v
) or die $Mail::Vail::User::Error;

$domain->enable_virus_scan(0);
$domain->ssl(0);
$domain->php(0);
$domain->php_cgi(0);
$domain->gzip(1);
$domain->frontpage(0);
$domain->name_based(1);
$domain->active(1);
$domain->mod_perl(1);

# override site_dir config
my $site_dir = $domain->home;
my $all_name = "$user_name.example.com";
my $most_domain = GPanel::Domain->new($all_name);
unless ($most_domain) {
    $most_domain = GPanel::Domain->add(
        user   => $user,
        domain => $all_name,
        ip     => $ip,
    );
}
$most_domain->mod_perl(1);
my $most_home = $most_domain->home;
make_dir ("$most_home/cache");
my $conf_dir = "$most_home/httpd";
my $most_conf = "$most_home/modperl.conf";
open my $fh, $most_conf
    or die "open $most_conf: $!";
my $port;
while (<$fh>) {
    if (/port\s+(\d+)/i) {
        $port = $1;
        last;
    }
}
close $fh;

unless (-d $conf_dir) {
    mkdir $conf_dir or die "mkdir $conf_dir: $!";
}
open my $new_conf_fh, ">$most_conf"
    or die "open $most_conf: $!";
open my $most_conf_fh, "/usr/local/mkdoc/conf/example.com.conf"
    or die "open /usr/local/mkdoc/conf/example.com.conf: $!";
while (<$most_conf_fh>) {
    s/%user%/$user_name/g;
    s/%site_dir%/$most_home/g;
    s/%port%/$port/g;
    print $new_conf_fh $_;
}
close $most_conf_fh;
close $new_conf_fh;
    
my $conf = "$conf_dir/$domain_name.conf";
#open my $fh, ">$conf" or die "Open $conf: $!";
open $fh, ">$conf" or die "Open $conf: $!";
my $env = <<END;
    PerlRequire MKDoc/Handler/Initialize.pm
    PerlInitHandler MKDoc::Handler::Initialize
# those env vars were generated by the Makefile, don't touch them!
    PerlSetEnv  PERL5LIB                /usr/local/mkdoc
    PerlSetEnv  MKDOC_DIR               /usr/local/mkdoc
    PerlSetEnv  SITE_DIR                $site_dir
    SetEnv      MKDOC_DIR               /usr/local/mkdoc
    SetEnv      SITE_DIR                $site_dir
    SetEnv      PUBLIC_DOMAIN           http://www.$domain_name/
    SetEnv      USER_DOMAIN             http://users.$domain_name/
    SetEnv      SERVER_ADMIN            "admin\@$domain_name"
    ServerAdmin "admin\@$domain_name"

    # where to cache stuff
    SetEnv  MKD__CACHE_DIR  "$site_dir/cache"

    SetEnv MKD__IMAP_SERVER             $MKDoc::Site::Config::CONFIG->{imap_host}
    SetEnv MKD__IMAP_USER               "$MKDoc::Site::Config::CONFIG->{imap_user}\@$domain_name"
    SetEnv MKD__IMAP_PASSWORD           $MKDoc::Site::Config::CONFIG->{imap_pass}

    # Optional stuff...

    # Uncomment if you want to change the HTML tidy command.
    SetEnv MKD__TIDY                    /usr/local/mkdoc/tools/whitelist.sh

    SetEnv MKD__URL_PORT_STRIP_REGEX  "80\\d*"

    # Uncomment if you want to change the number of posts per page on discussion boards.
    # SetEnv MKD__PLUGIN_DISCUSSION_PER_PAGE    50

    # Uncomment if you want to change the width / height of the photo thumbnails
    # SetEnv MKD__PLUGIN_PHOTO_THUMB_X    320
    # SetEnv MKD__PLUGIN_PHOTO_THUMB_Y    200

    # Uncomment if you want to change the width / height of the photo scaled images
    # SetEnv MKD__PLUGIN_PHOTO_SCALED_X   640
    # SetEnv MKD__PLUGIN_PHOTO_SCALED_Y   480

    # Uncomment if you want to change the amount of returned results
    # per page on the search page
    # SetEnv MKD__PLUGIN_SEARCH_PER_PAGE  10

    # Uncomment if you want to change the depth of the sitemap
    # SetEnv MKD__PLUGIN_SITEMAP_DEPTH    2

    # Uncomment if you want to change the list of allowed tags in HTML components
    # SetEnv MKD__XHTML_FILTER_LIST       /usr/local/mkdoc/conf/xhtml_filter.conf

    # Uncomment if you want to change the HTML tidy configuration file.
    # SetEnv MKD__TIDY_CONF               /usr/local/mkdoc/custom_tidy_config.conf
END
my $alias = <<END;
    RedirectMatch permanent .+/\.sitemap\.html\$ http://www.$domain_name/.sitemap.html
    Alias /.static/css    $site_dir/resources/skin
    Alias /.static        $site_dir/static

    <Location /.server-status>
        SetHandler server-status
    </Location>
    <Location /.perl-status>
        require valid-user
        SetHandler perl-script
        PerlHandler Apache::Status
    </Location>
    RedirectMatch ^/.logs\$ http://www.$domain_name/.logs/
    <Directory $site_dir/logs/>
        Options Indexes
    </Directory>
    Alias /.logs/ $site_dir/logs/

    Alias /               /usr/local/mkdoc/cgi/mkdoc.cgi/
END
my $handler = <<END;
    PerlRequire MKDoc/Handler/Initialize.pm
    PerlInitHandler MKDoc::Handler::Initialize
END
print $fh <<END;
<VirtualHost *>
    ServerName    $domain_name
    ServerAlias   $domain_name.mkdoc.net
    ErrorLog $site_dir/logs/perl_error_log
    #CustomLog $site_dir/logs/perl_access_log combined
    Redirect permanent / http://www.$domain_name/
</VirtualHost>

<VirtualHost *>
    ServerName    www.$domain_name
    ServerAlias   www.$domain_name.mkdoc.net
    SetEnv        MKD__PLUGIN_LIST /usr/local/mkdoc/conf/www.conf
    ErrorLog $site_dir/logs/perl_error_log
    #CustomLog $site_dir/logs/perl_access_log combined
$handler
$env
$alias
</VirtualHost>

<VirtualHost *>
    ServerName            users.$domain_name
    ServerAlias           users.$domain_name.mkdoc.net
    SetEnv                MKD__PLUGIN_LIST        /usr/local/mkdoc/conf/users.conf
    ErrorLog $site_dir/logs/perl_error_log
    #CustomLog $site_dir/logs/perl_access_log combined
$handler
$env
$alias
    <Location />
        PerlAuthenHandler     MKDoc::Handler::Authenticate
        AuthName "Please enter your user credentials"
        AuthType Basic
        require valid-user
    </Location>
</VirtualHost>

END
close $fh;
undef $domain;
{
#    my $port;
#    local (@ARGV) = ("/etc/httpd/vhost/$domain_name.conf");
#    while (<>) {
#        if (/localhost:(\d+)/) {
#            $port = $1;
#        }
#    }
    local ($^I, @ARGV) = ('', "/etc/httpd/vhost/$domain_name.conf");
    while (<>) {
        s/:-1/:$port/;
        print;
    }
}

system("/usr/sbin/service modperl halt $domain_name");
system("/usr/sbin/service modperl restart $all_name");
system ("/usr/sbin/service httpd restart");

@{$MKDoc::Site::Config::CONFIG}{qw/site_dir SITE_DIR/} = ($site_dir, $site_dir); # "$home/$domain_name";
$MKDoc::Site::Config::CONFIG->{database_pass} = $::ADMIN_PASSWD;
$MKDoc::Site::Config::CONFIG->{DATABASE_PASS} = $MKDoc::Site::Config::CONFIG->{database_pass};
_create_database_unless_exists();



$::LOG_DIR = $ENV{LOG_PREFIX} ?
do {
    my $dir = $MKDoc::Site::Config::CONFIG->{'site_dir'};
    $dir =~ s/^.*\///;
    $dir =~ s/\/$//;

    my $prefix = $ENV{LOG_PREFIX};
    $prefix =~ s/\/$//;

    "$prefix/$dir";
} : $site_dir . '/logs';


$::CACHE_DIR = $ENV{CACHE_PREFIX} ?
do {
    my $dir = $MKDoc::Site::Config::CONFIG->{'site_dir'};
    $dir =~ s/^.*\///;
    $dir =~ s/\/$//;

    my $prefix = $ENV{CACHE_PREFIX};
    $prefix =~ s/\/$//;

    "$prefix/$dir";
} : $site_dir . '/cache';


$::TEMP_DIR = $ENV{TEMP_PREFIX} ?
do {
    my $dir = $MKDoc::Site::Config::CONFIG->{'site_dir'};
    $dir =~ s/^.*\///;
    $dir =~ s/\/$//;

    my $prefix = $ENV{TEMP_PREFIX};
    $prefix =~ s/\/$//;

    "$prefix/$dir";
} : undef;


print "\n";
setup_files();

# print "\nWriting apache config files\n";
# MKDoc::Site::ConfigWriter::Httpd_Conf->setup();


MKDoc::Site::Deploy::DB->setup();
MKDoc::Site::ConfigWriter::MKDocRegistrer->setup();

my $admin = MKDoc::Site::ConfigWriter->site_user_domain;
$admin    = MKDoc::Site::ConfigWriter->is_site_user_domain_https() ? "https://$admin/" : "http://$admin/";

print <<EOF;

Your mkdoc site has been installed. You should now restart
your http server. Once this is done, go to the following
address:

  $admin

EOF

$::KEEP_TABLES && do {
print <<EOF;
Since you chose to keep your existing database, your admin
password has not been changed.

EOF
};

$::KEEP_TABLES || do {
print <<EOF;
Your default connection parameters will be:

  user: admin
  password: $::ADMIN_PASSWD

EOF
};

sub setup_files
{
    my $config        = $MKDoc::Site::Config::CONFIG;
    my $site_dir      = $config->{'site_dir'};
    my $server_admin  = $config->{'server_admin'};
    my $public_domain = $config->{'public_domain'};
    my $user_domain   = $config->{'user_domain'};
 
    make_dir ("$site_dir");
    make_dir ("$site_dir/su");
    make_dir ("$site_dir/httpd");
    make_dir ("$site_dir/resources");
    make_dir ("$site_dir/resources/templates");
    make_dir ("$site_dir/resources/skin");
    system "cp -a  $ENV{MKDOC_DIR}/skin/* $site_dir/resources/skin";
    make_dir ("$site_dir/data");
    make_dir ("$site_dir/static");
    make_dir ("$site_dir/static/files");
    make_dir ("$site_dir/static/images");
    make_dir ($::LOG_DIR);
    make_dir ($::TEMP_DIR);
    make_dir ($::CACHE_DIR);
    
    # install mksetenv script
    open FP, ">$site_dir/mksetenv.sh" || do {
        warn "Cannot write-open '$site_dir/mksetenv.sh'";
        return;
    };

    print FP join "\n", (
        qq |source $ENV{MKDOC_DIR}/mksetenv.sh|, 
        qq |export SITE_DIR="$site_dir"|,
        qq |export SERVER_ADMIN="$server_admin"|,
        qq |export PUBLIC_DOMAIN="$public_domain"|,
        qq |export USER_DOMAIN="$user_domain"|, ''
    );

    close FP;
    system ("chown $user_name:$user_name $site_dir/mksetenv.sh");
}


sub make_dir
{
    my $dir = shift || return;
    print "Creating $dir\n";
    -d $dir and return;
    mkdir $dir || die "Cannot create $dir!";
    system ("chown $user_name:$user_name $dir");
}



sub _create_database_unless_exists
{
    my $config      = $MKDoc::Site::Config::CONFIG;
    my $driver      = new MKDoc::Site::Deploy::DB::Driver;
    my $driver_code = $driver->generate_driver ($config)  || return;
    eval $driver_code;
    die "$@" if $@;
    local $SIG{__WARN__} = sub {};
    eval { lib::sql::DBH->get() };
    $@ && _create_database();
}
   

sub _create_database
{
    my $config      = $MKDoc::Site::Config::CONFIG;

    my $database = $config->{database_name};
    if (!$database) {
        die ("You must specify a database name");
    }
    if (length($database) > 64) {
        die ("Length of a database name can not be greater than 64");
    }
    my $login = $config->{database_user};
    if (!$login) {
        die ("You must specify a login");
    }
    if (length($login) > 16) {
        die ("Login name can not be greater than 16 characters");
    }
    my $pass1 = $config->{database_pass};


    my @opts = qw/
        select
        insert
        update
        delete
        create
        drop
        file
        index
        alter
        create_tmp_table
        lock_tables
    /;

    my %priv = map { "priv_" . $_, 1 } @opts; 

    GPanel::MySQL->create(
        database   => $database,
        login      => $login,
        password   => $pass1,
        localhost  => 1,
        %priv
    ) or die ("Error creating database: $GPanel::MySQL::error");

    print "Created $database\n";
}


## Add the FTP user
print "Creating FTP user...\n";
eval {
    use GPanel::ProFTPD;
    GPanel::ProFTPD->user_add (
        user_name      => $user_name, #$MKDoc::Site::Config::CONFIG->;
        ftp_user_name  => $MKDoc::Site::Config::CONFIG->{database_user},
        passwd         => $MKDoc::Site::Config::CONFIG->{database_pass},
        crypt_passwd   => 1,
        root_directory => "$site_dir/resources",
    ) or die $GPanel::ProFTPD::error;

    my $ret = GPanel::ProFTPD->limit_add (
        user_name      => $user_name,
        ftp_user_name  => $MKDoc::Site::Config::CONFIG->{database_user},
        directory      => "$site_dir/resources",
        deny           => 0,
        limits         => [ qw/ALL/ ],
    ) or die $GPanel::ProFTPD::error;

    print "FTP Login: $MKDoc::Site::Config::CONFIG->{database_user}\n";
    print "FTP Pass:  $MKDoc::Site::Config::CONFIG->{database_pass}\n";
};
$@ && warn $@;


1;
