#!/usr/bin/perl
package MKDoc::Bin::Freeze;
use strict;
use warnings;

BEGIN {
    $ENV{MKDOC_DIR} || die 'MKDOC_DIR is not defined';
    $ENV{SITE_DIR}  || die 'SITE_DIR is not defined';
    
    unshift (@INC, $ENV{MKDOC_DIR});
};


sub __init__
{
    eval "use MKDoc";
    $@ and die $@;
    
    eval "use MKDoc::Handler::Initialize";
    $@ and die $@;

    MKDoc::Handler::Initialize::handler();
}


sub handler
{
    __init__();
    my $class = shift;
    my $path = shift;
    
    my $document_t = flo::Standard::table ('Document');
    my $document = $document_t->get (Full_Path => $path) or
       die "document $path could not be found";
    
    foreach my $field (keys %{$document})
    {
	next if ($field eq 'Body');
	next if ($field eq 'Sibling_Position');
	next if ($field eq 'Parent_ID');
	next if ($field eq 'Full_Path');
	next if ($field eq 'ID');
	next if ($field eq 'Editor_ID');
	
	my $data = $document->{$field} || '';
	$data =~ s/\n(?! )/\n /gsm;
	print "$field: $data\n";
    }
    
    print "\n";
    print $document->{Body};
}


package main;
use strict;
use warnings;

my $path = shift (@ARGV) || die "Usage: $0 <path>";
MKDoc::Bin::Freeze->handler ($path);


1;
