#!/usr/bin/perl
package NamedFileIO;
use base qw /IO::File/;
use overload '""' => sub { return $Name };

our $Name = undef;

sub new
{
    my $class = shift;
    $Name     = $_[0];
    return $class->SUPER::new (@_);
}


package FakeCGI;

sub new   { my $class = shift; return bless { @_ }, $class }
sub param { my $self  = shift; return $self->{shift()}     }


package MKDoc::Bin::Photo;
use Image::Magick;
use strict;
use warnings;

BEGIN {
    $ENV{MKDOC_DIR} || die 'MKDOC_DIR is not defined';
    $ENV{SITE_DIR}  || die 'SITE_DIR is not defined';
    
    unshift (@INC, $ENV{MKDOC_DIR});
};


sub __init__
{
    eval "use MKDoc";
    $@ and die $@;
    
    eval "use MKDoc::Handler::Initialize";
    $@ and die $@;
    
    eval "use flo::Editor";
    $@ and die $@;
    
    eval "use flo::editor::Photo";
    $@ and die $@;
    
    MKDoc::Handler::Initialize::handler();
}


sub handler
{
    __init__();
    my $class = shift;
    my $path  = shift;
    my $photo = shift;

    my $document_t = flo::Standard::table ('Document');
    my $document   = $document_t->get (Full_Path => $path) or die "document $path could not be found";

    my $cgi = new FakeCGI (
        fake_alt         => $photo,
        fake_description => $photo,
        fake_creator     => 'mkphotoattach.pl',
        fake_date        => $document->now_day_iso(),
        fake_rights      => '',
        fake_coverage    => '',
        fake_upload      => $photo,
        fake             => new NamedFileIO ($photo),
    );

    my $photo_obj = new flo::editor::Photo (
        param_name => 'fake',
        cgi        => $cgi
    );

    my $editor = new flo::Editor();
    $editor->parse_xml ($document->{Body});
    $editor->add_component ($document, $photo_obj);
    
    $document->{Body} = $editor->generate_xml();
    $document->save();
}


package main;
use strict;
use warnings;

my $path  = shift (@ARGV) || die "Usage: $0 <path> photo1 photo2 photo3...";
while ($_ = shift @ARGV) {
  -e $_ || do { warn "$_ doesn't seem to exist"; 1     } && next;
  -f $_ || do { warn "$_ doesn't seem to be a file"; 1 } && next;
  print "Processing $_...\n";
  MKDoc::Bin::Photo->handler ($path, $_);
}

1;
