#!/usr/bin/perl
package MKDoc::Bin::Thaw;
use strict;
use warnings;

BEGIN {
    $ENV{MKDOC_DIR} || die 'MKDOC_DIR is not defined';
    $ENV{SITE_DIR}  || die 'SITE_DIR is not defined';
    
    unshift (@INC, $ENV{MKDOC_DIR});
};


sub __init__
{
    eval "use MKDoc";
    $@ and die $@;
    
    eval "use MKDoc::Handler::Initialize";
    $@ and die $@;

    MKDoc::Handler::Initialize::handler();
}


sub check_path_noexists
{
    my $class = shift;
    my $path = shift;
    my $document_t = flo::Standard::table ('Document');
    my $document = $document_t->get (Full_Path => $path) and do {
	warn "document $path already exists";
	return;
    };
    
    return 1;
}


sub parent_from_path
{
    my $class = shift;
    my $path = shift;
    $path =~ s/\/$//;
    ($path) = $path =~ /(.*)\/(.*)/;
    defined $path or die 'could not extract parent path';
    $path .= '/';
    
    my $document_t = flo::Standard::table ('Document');
    my $document = $document_t->get (Full_Path => $path) or do {
	warn "document $path does not seem to exist";
	return;
    };
    
    return $document;
}


sub handler
{
    __init__();
    my $class = shift;
    my $path  = shift;
    my $data  = shift;
    
    $class->check_path_noexists ($path) || return;
    my $parent = $class->parent_from_path ($path) || return;
    
    my $newdoc = {};
    my $current_field = 'undef';
    
    my @lines = split /\n/sm, $data;
    while (@lines)
    {
	my $line = shift (@lines);
	length ($line) or last;
	
	$line =~ /^ / and do {
	    $newdoc->{$current_field} .= $line;
	    next;
	};
	
	my ($key, $val) = split /\:/, $line, 2;
	$val =~ s/^\s+//;
	$newdoc->{$key} = $val;
    }
    
    $newdoc->{Body} = join "\n", @lines;
    $newdoc->{Parent_ID} = $parent->id();
    $newdoc->{Editor_Created_ID} = 1;
    $newdoc->{Editor_Last_Modified_ID} = 1;
    $newdoc->{Name} = do {
	$path =~ s/\/$//;
	$path =~ s/.*\///;
	$path;
    };
    $newdoc->{Template}      ||= 'default';
    $newdoc->{Cache_Control} ||= '10';
    
    my $document_t = flo::Standard::table ('Document');
    $document_t->insert ($newdoc);
}


package main;
use strict;
use warnings;

my $path = shift (@ARGV) || die "Usage: $0 <path>";
my @data = ();
push @data, $_ while ($_ = <STDIN>);
scalar @data or die 'no input data...';

MKDoc::Bin::Thaw->handler ($path, (join '', @data));


1;
