# -------------------------------------------------------------------------------------
# MKDoc::CGI
# -------------------------------------------------------------------------------------
#
#       Author : Jean-Michel Hiver.
#    Copyright : (c) MKDoc Holdings Ltd., 2002.
# 
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Description:
#
#      This module is a subclass of CGI.pm, it fixes an Apache-related CGI.pm
#      bug and also marks all the incoming parameters as UTF-8 strings.
#
# -------------------------------------------------------------------------------------
package MKDoc::CGI::CompileMe;
use CGI qw(-compile :all);

package MKDoc::CGI;
use strict;
use warnings;
use 5.008_000;
use Encode;
use base qw /CGI/;


sub get
{
    my $class = shift;
    $class = ref $class || $class;

    $::MKD_CGI ||= $class->new();
    return $::MKD_CGI;
}


##
# $self->self_url;
# ----------------
# Returns the URI of the current CGI object
##
sub self_url
{
    my $self = shift;
    my $url = $self->url ( -relative  => 0,
			   -path_info => 1,
			   -query     => 1 );
    
    # httpd.conf example:
    #   SetEnv MKD__URL_PORT_STRIP "80,8080"
    #   SetEnv MKD__URL_PORT_STRIP_REGEX  "80\d*"
    my $port_strip = $ENV{MKD__URL_PORT_STRIP} || '';
    my $port_strip_regex = $ENV{MKD__URL_PORT_STRIP_REGEX} || '';

    # change commas to regex alternator
    $port_strip =~ tr/,/|/;
    my $port_strip_str = $port_strip || $port_strip_regex || '80';

    # assumes url always has a port specifier
    $url =~ s/(.*?\:\/\/(?:.*?\@)?)(.*):(?:${port_strip_str})(?!\d)(.*)/$1$2$3/
        if ($url =~ /(.*?\:\/\/(?:.*?\@)?)(.*):${port_strip_str}(?!\d)(.*)/);

    return $url;
}


sub delete
{
    my $self = shift;
    while (@_) { $self->SUPER::delete (shift()) };
}


sub delete_all_fast
{
    my $self = shift;
    $self->{'.parameters'} = [];
}


sub is_upload
{
    my ($self, $param_name) = @_;
    my @param = grep(ref && fileno($_), $self->SUPER::param ($param_name));
    return unless @param; 
    return wantarray ? @param : $param[0];
}


sub param
{
    my $self  = shift;
    my $key   = shift || return $self->SUPER::param ();

    $self->is_upload ($key => @_) and return $self->SUPER::param ($key => @_);
    @_                            and return $self->SUPER::param ($key => @_);

    my @res = $self->SUPER::param ($key);
    @res = map {
        (defined $_) ? do {
            my $res = $_;
            my $octets = $_;
            my $string = Encode::decode_utf8 ($octets, Encode::FB_PERLQQ);
            $string;
        } : undef
    } @res;

=cut

    @_ and do {
        $self->{'.params_cached__'} ||= {};
        delete $self->{'.params_cached__'}->{$key};
        return $self->SUPER::param ($key => @_);
    };
    
    $self->{'.params_cached__'} ||= {};
    $self->{'.params_cached__'}->{$key} ||= do {
        my @res = $self->SUPER::param ($key);
        @res = map {
            my $octets = $_;
            my $string = Encode::decode_utf8 ($octets);
            $string;
        } @res;

        \@res;
    };

    use Data::Dumper;
    warn Dumper ( $self->{'.params_cached__'}->{$key} );

    my @res = @{ $self->{'.params_cached__'}->{$key} };

=cut

    @res == 0 and return;
    @res == 1 and return shift @res;
    return wantarray ? @res : \@res;
}


# redirect() doesn't seem to work with CGI.pm 2.89
# this should fix for this particular version.
sub redirect
{
    my $self = shift;
    my $uri  = shift;
    my $res  = '';
    $res .= "Status: 302 Moved\n";
    $res .= "Location: $uri\n\n";
    return $res;
}


sub param_eq
{
    my $self  = shift;
    my $param = $self->param (shift());
    my $value = shift;
    return unless (defined $param);
    return unless (defined $value);
    return $param eq $value;
}


sub path_info_eq
{
    my $self  = shift;
    my $param = $self->path_info();
    my $value = shift;
    return unless (defined $param);
    return unless (defined $value);
    return $param eq $value;
}


sub path_info_equals
{
    my $self = shift;
    return $self->path_info_eq (@_);
}


sub path_info_starts_with
{
    my $self  = shift;
    my $param = $self->path_info();
    my $value = quotemeta (shift);
    return $param =~ /^$value/;
}


1;
