# -------------------------------------------------------------------------------------
# MKDoc::ECommerce::Rules
# -------------------------------------------------------------------------------------
# Author : Jean-Michel Hiver.
# Copyright : (c) MKDoc Holdings Ltd, 2003
#
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# Billing Rules can become very, very complicated and ugly. This module attempts to
# sort of sort out this ugly mess.
# -------------------------------------------------------------------------------------
package MKDoc::ECommerce::Rules;
use MKDoc::Control_List;
use strict;
use warnings;

our @LIST = ();
our $Self = undef;


sub no_warnings { $::Rules }


sub new
{
    my $class = shift;
    my $self  = bless { @_ }, $class;
}


# returns a list of hashes comprising three fields:
# { title  => $title
#   desc   => $description
#   amount => $new_amount }
sub explain
{
    my $self = shift;
    my $billing = $ENV{ECOMMERCE_BILLING_RULES} || $ENV{MKDOC_DIR} . '/conf/plugin_ecommerce.conf';
    
    # no rules specified? return the total price...
    my @res = { amount => $self->{basket}->total() };
    $billing && -e $billing || return wantarray ? @res : \@res;
    
    my $control = new MKDoc::Control_List ( file => $billing );
    $::Rules = $self;
    
    @res = $control->process();

    my $prev = $self->{basket}->total();
    for (@res)
    {
        $_->{title}  = $_->{title}->($prev)  if ( ref $_->{title} );
        $_->{desc}   = $_->{desc}->($prev)   if ( ref $_->{desc} );
        $_->{amount} = $_->{amount}->($prev) if ( ref $_->{amount} );
        $prev = $_->{amount};
    }

    return wantarray ? @res : \@res;
}


sub deal_price
{
    my $self    = shift;
    my @results = reverse $self->explain();
    return $results[0]->{amount};
}


1;


__END__
