package MKDoc::SimplePersistence;
use strict;
use warnings;
use Cache::FileCache;
use MKDoc::Config;
use Data::Dumper;


##
# $class->load ($id);
# -------------------
# Instanciates a new MKDoc::SimplePersistent using the id $id.
##
sub load
{
    my $class      = shift;
    my $id         = shift || return;
    my $cache      = $class->cache_object();
    my $data       = $cache->get ($id) || return;
    my $VAR1       = undef;
    eval "$data";
    return $VAR1;
}


##
# $self->save();
# --------------
# Saves the current MKDoc::Session state.
##
sub save
{
    my $self       = shift;
    $self->{id}  ||= $self->_gen_id();
    
    my $cache      = $self->cache_object();
    my $data       = Dumper ($self);
    $cache->set ($self->{id}, $data);
}


##
# $self->cache_object();
# ----------------------
# Returns the object that we use to cache cookie values.
##
sub cache_object
{
    my $self = shift;
    my $class = ref $self || $self;
    
    my $namespace = $class;
    $namespace    = lc ($namespace);
    $namespace    =~ s/::/_/g;
    
    my %opt = (
        cache_root         => MKDoc::Config->DATA_DIR,
	namespace          => $namespace,
        default_expires_in => 3600 * 24 * 366,
    );
    
    return new Cache::FileCache ( \%opt );
}


sub id
{
    my $self = shift;
    return $self->{id};
}


sub _gen_id
{
    my $class = shift;
    join '', map { chr (ord ('a') + int (rand 26)) } 1..20;
}


1;


__END__
