# -------------------------------------------------------------------------------------
# flo::Object
# -------------------------------------------------------------------------------------
#
#       Author : Jean-Michel Hiver.
#    Copyright : (c) MKDoc Holdings Ltd, 2001
#
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# 
#    Description:
#
#      Base class for all flo::* objects mainly providing a config class method
#
# -------------------------------------------------------------------------------------
package flo::Object;
use MKDoc::Config;
use strict;
use CGI::Carp;

$Petal::Hash::MODIFIERS->{'config:'} = sub {
    my $hash  = shift;
    my $key   = shift;
    return MKDoc::Config->$key();
};


##
# $class->config;
# ---------------
#   Returns the configuration parameters of that class as a
#   hash reference
##
sub config
{
    my $class = shift;
    $class = ref $class || $class;
    
    # compute the config file name from the class name
    my $file = $class;
    $file =~ s/\.pm$//;
    $file =~ s/::/./g;
    
    my $ret = new MKDoc::Config ($file) or
        confess "Cannot find config file $file";
    
    return $ret->hash;
}




1;


