# -------------------------------------------------------------------------------------
# flo::editor::Mixin::hr_name
# -------------------------------------------------------------------------------------
#
#       Author : Jean-Michel Hiver.
#    Copyright : (c) MKDoc Holdings Ltd, 2001
#
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
#    Description:
#
#      Mixin to compute human readable names from normalized MKDoc names
#
# -------------------------------------------------------------------------------------
package flo::editor::Mixin::hr_name;
use strict;


##
# $class->hr_name;
# ----------------
#   Static method that computes a human readable names from a
#   normalized MKDoc name.
##
sub hr_name
{
    my $class = shift;
    my $string = shift;
    return unless (defined $string);
    
    $string =~ s/\..*?$//;
    $string =~ s/-/ /g;
    $string =~ s/\b(\w)/\U$1/g;
    return $string;
}


1;
