# -------------------------------------------------------------------------------------
# flo::editor::Mixin::normalize_name
# -------------------------------------------------------------------------------------
#
#       Author : Jean-Michel Hiver.
#    Copyright : (c) MKDoc Holdings Ltd, 2001
#
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# 
#    Description:
#
#      Mixin to make file, images, photos, etc... names look better
#
# -------------------------------------------------------------------------------------
package flo::editor::Mixin::normalize_name;
use strict;


sub preferred_uri_name
{
    my $self = shift;
    my $name = $self->can ('title') ?
        $self->title :
	$self->type  ;
    
    return $self->normalize_name_nodot ($name);
}


sub normalize_name_nodot
{
    my $class = shift;
    my $name  = shift;
    $name = lc ($name);
    $name =~ s/\.[^.]+(\.gz)?$//;
    $name =~ s/[^a-z0-9-]/ /g;
    $name =~ s/\s+/-/g;
    $name =~ s/\-+/-/g;
    $name =~ s/^\-+//g;
    $name =~ s/\-+$//g;
    $name ||= $class->type();
    return $name;
}


sub normalize_name
{
    my $class = shift;
    my $name  = shift;
    $name = lc ($name);
    $name =~ s/[^a-z0-9-.]/ /g;
    $name =~ s/\s+/-/g;
    $name =~ s/^\-+//g;
    $name =~ s/\-+$//g;
    $name ||= $class->type();
    return $name;
}


1;
