# -------------------------------------------------------------------------------------
# flo::editor::Text
# -------------------------------------------------------------------------------------
# Author : Jean-Michel Hiver.
# Copyright : (c) MKDoc Holdings Ltd, 2003
#
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------------------
package flo::editor::Text;
use flo::Editor;
use flo::Standard;
use MKDoc::CGI;
use MKDoc::XML::Tagger::Preserve;
use MKDoc::Text::Structured;
use strict;

use flo::Component;
use base qw /flo::Component
	     flo::editor::Mixin::compute_name
	     flo::editor::Mixin::normalize_name/;


sub preferred_extension { 'txt' }


sub new
{
    my $class = shift;
    $class    = ref $class || $class;
    my $self  = bless { @_ }, $class;
    
    my $cgi = $self->{cgi};
    my $param_name = $self->{param_name};
    if (defined $cgi)
    {
	if (defined $cgi->param ($param_name . "_add"))
	{
	    $self->{data} = "";
	}
	else
	{
	    $self->{data} = $cgi->param ($param_name);
	}
    }
    else
    {
	$self->{data} = "";
    }
    
    $self->_initialize;
    return $self;
}


sub html
{
    my $self = shift;
    my $data = $self->{'data'};
    $data = MKDoc::Text::Structured::process ($data);
    $data = "<div class=\"text\">$data</div>";
    
    my @newl = $self->links_for_tagger();
    my $res = MKDoc::XML::Tagger::Preserve->process_data (['a'], $data, @newl);
    return $res;
}


sub parse_xml
{
    my $self = shift;
    my $data = shift;

    $data !~ /^<perl/ and $data !~ /^<hash/ and do {
	$self->{data} = $data;
	$self->{data} =~ s/\&lt\;/</g;
	$self->{data} =~ s/\&gt\;/>/g;
	$self->{data} =~ s/\&amp\;/&/g;
	$self->{data} =~ s/\&quot\;/\"/g;
        return $self;
    };

    $self->SUPER::parse_xml ($data, @_);
}


sub as_xhtml { return shift()->html() }


1;
