# -------------------------------------------------------------------------------------
# flo::plugin::Account::Reminder
# -------------------------------------------------------------------------------------
#       Author : Steve Purkis <spurkis@mkdoc.com>
#    Copyright : (c) 2002, MKDoc Holdings Ltd.
#
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
# flo::plugin::Account::Reminder - Account reminder plugin for MKDoc.
# This plugin lets an existing user receive their account details by email.
# -------------------------------------------------------------------------------------
package flo::plugin::Account::Reminder;
use MKDoc::Ouch;
use flo::Standard qw /cgi/;
use flo::Record::Editor;
use Carp;
use Petal;
use Petal::Mail;

use strict;
use 5.008_000;
use utf8;


use base qw /flo::Plugin/;


sub template_path { '/account/reminder' }


##
# $self->http_get;
# ----------------
# Displays the form which lets the editor choose which audiences
# the current document relates to.
##
sub http_get
{
    my $self = shift;
    $self->render_http (
	self       => $self,
	object     => $self->parent,
	__input__  => 'XML',
	__output__ => 'XHTML',
       );    
    return 'TERMINATE';
}


##
# $self->http_post;
# -----------------
# Reflect the changes on the database and redirects to
# current document.
##
sub http_post
{
    my $self = shift;
    my $cgix = flo::Standard::cgi()->new;
    my $data = $cgix->param ('q') or do {
	new MKDoc::Ouch 'reminder/no_data';
	return $self->http_get;
    };
    
    my $editor_t = flo::Standard::table ('Editor');
    my $condition = new lib::sql::Condition();
    $condition->boolean ('OR');
    $condition->add ('Login', '=', $data);
    $condition->add ('Email', '=', $data);
    
    my $query = $editor_t->search ($condition);
    my $count = 0;
    while (my $editor = $query->next())
    {
	$self->{user} = $editor;
	$self->_send_mail();
	$count++;
    }
    
    $self->{is_post} = 1;
    $self->{count}   = $count;
    $count == 0 and do {
	new MKDoc::Ouch 'reminder/no_match';
    };
    
    return $self->http_get;
}


sub user
{
    my $self = shift;
    return $self->{user};
}


##
# $self->_send_mail;
# ------------------
# Sends the email...
##
sub _send_mail
{
    my $self   = shift;
    
    my $xml_mail = eval {
        my $mail = new Petal::Mail (
            file     => '/account/emails/reminder',
            language => $self->language(),
        );

	$mail->send (
	    self       => $self,
	    object     => $self->parent(),
	    __input__  => 'XML',
	    __output__ => 'XML',
	);
    };

    defined $@ and $@ and do {
	warn $@;
	new MKDoc::Ouch 'mail/cannot_send';
	return 0;
    };
}


1;


__END__
