package flo::plugin::Admin::AudienceList;
use strict;
use warnings;
use flo::Standard;
use base qw /flo::Plugin/;


sub activate
{
    my $self = shift;
    $self->SUPER::activate (@_) || return;
    $self->user()->id() == 1    || return;
    return 1;
}


sub template_path { 'admin/audience_list' }


sub http_get
{
    my $self = shift;
    $self->render_http (
	self => $self,
	__output__ => 'XHTML',
       );
    
    return 'TERMINATE';
}


sub audiences
{
    my $self = shift;
    my $audience_t = flo::Standard::table ('Audience');
    my @res = $audience_t->select (
	cols => '*',
	sort => [ 'Label' ],
	desc => 0,
       )->fetch_all();

    return wantarray ? @res : \@res;
}


1;
