package flo::plugin::Admin::AudienceModify;
use strict;
use warnings;
use flo::Standard;
use flo::Record::Editor;
use base qw /flo::Plugin/;


sub activate
{
    my $self = shift;
    $self->SUPER::activate (@_) || return;
    $self->SUPER::user()->id() == 1    || return;
    
    my $cgi = $self->cgi();
    my $audience_id = $cgi->param ('id') || return;
    my $audience_t = flo::Standard::table ('Audience');
    $self->{audience} = $audience_t->get ($audience_id) || return;
    
    return 1;
}


sub audience
{
    my $self = shift;
    return $self->{audience};
}


sub template_path { 'admin/audience_modify' }


sub http_get
{
    my $self = shift;
    $self->render_http (
	self => $self,
	__output__ => 'XHTML',
       );
    
    return 'TERMINATE';
}


sub http_post
{
    my $self = shift;
    my $cgi  = flo::Standard::cgi();
    
    my $audience_t = flo::Standard::table ('Audience');
    my $audience = $self->audience();
    $audience->set_label ($cgi->param ('label'));
    
    $audience->label() or do {
	new MKDoc::Ouch 'audience/label/empty';
	return $self->http_get();
    };
    
    length ($audience->label()) < 255 or do {
	new MKDoc::Ouch 'audience/label/too_long';
	return $self->http_get();
    };
    
    $self->has_errors() and return $self->http_get();
    $audience_t->modify ($audience);
    
    $self->{ok} = 1;
    return $self->http_get();
}


sub label
{
    my $self = shift;
    my $cgi  = flo::Standard::cgi();
    return $cgi->param ('label') || $self->audience()->label();
}


1;
